/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.melting;

import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.recipe.IMultiRecipe;
import slimeknights.mantle.recipe.helper.LoggingRecipeSerializer;
import slimeknights.mantle.recipe.helper.RecipeHelper;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialCastingLookup;
import slimeknights.tconstruct.library.recipe.ingredient.MaterialIngredient;
import slimeknights.tconstruct.library.recipe.melting.IMeltingContainer;
import slimeknights.tconstruct.library.recipe.melting.IMeltingRecipe;
import slimeknights.tconstruct.library.recipe.melting.MeltingRecipe;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class MaterialMeltingRecipe
implements IMeltingRecipe,
IMultiRecipe<MeltingRecipe> {
    private final ResourceLocation id;
    private final MaterialVariant input;
    private final int temperature;
    private final FluidStack result;
    private List<MeltingRecipe> multiRecipes = null;

    public MaterialMeltingRecipe(ResourceLocation id, MaterialVariantId input, int temperature, FluidStack result) {
        this.id = id;
        this.input = MaterialVariant.of(input);
        this.temperature = temperature;
        this.result = result;
    }

    public boolean matches(IMeltingContainer inv, Level worldIn) {
        if (this.input.isUnknown()) {
            return false;
        }
        ItemStack stack = inv.getStack();
        if (stack.m_41619_() || MaterialCastingLookup.getItemCost(stack.m_41720_()) == 0) {
            return false;
        }
        return this.input.matchesVariant(stack);
    }

    @Override
    public int getTemperature(IMeltingContainer inv) {
        return this.temperature;
    }

    @Override
    public int getTime(IMeltingContainer inv) {
        int cost = MaterialCastingLookup.getItemCost(inv.getStack().m_41720_());
        return IMeltingRecipe.calcTimeForAmount(this.temperature, this.result.getAmount() * cost);
    }

    @Override
    public FluidStack getOutput(IMeltingContainer inv) {
        int cost = MaterialCastingLookup.getItemCost(inv.getStack().m_41720_());
        return new FluidStack(this.result, this.result.getAmount() * cost);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerSmeltery.materialMeltingSerializer.get();
    }

    public List<MeltingRecipe> getRecipes() {
        if (this.multiRecipes == null) {
            if (this.input.get().isHidden()) {
                this.multiRecipes = Collections.emptyList();
            } else {
                MaterialId inputId = this.input.getId();
                this.multiRecipes = MaterialCastingLookup.getAllItemCosts().stream().filter(entry -> ((IMaterialItem)entry.getKey()).canUseMaterial(inputId)).map(entry -> {
                    FluidStack output = this.result;
                    if (entry.getIntValue() != 1) {
                        output = new FluidStack(output, output.getAmount() * entry.getIntValue());
                    }
                    return new MeltingRecipe(this.id, "", MaterialIngredient.fromItem((IMaterialItem)entry.getKey(), inputId), output, this.temperature, IMeltingRecipe.calcTimeForAmount(this.temperature, output.getAmount()), Collections.emptyList());
                }).collect(Collectors.toList());
            }
        }
        return this.multiRecipes;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public static class Serializer
    extends LoggingRecipeSerializer<MaterialMeltingRecipe> {
        public MaterialMeltingRecipe fromJson(ResourceLocation id, JsonObject json) {
            MaterialVariantId inputId = MaterialVariantId.fromJson(json, "input");
            int temperature = GsonHelper.m_13927_((JsonObject)json, (String)"temperature");
            FluidStack output = RecipeHelper.deserializeFluidStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            return new MaterialMeltingRecipe(id, inputId, temperature, output);
        }

        @Nullable
        protected MaterialMeltingRecipe fromNetworkSafe(ResourceLocation id, FriendlyByteBuf buffer) {
            MaterialVariantId inputId = MaterialVariantId.parse(buffer.m_130136_(Short.MAX_VALUE));
            int temperature = buffer.readInt();
            FluidStack output = FluidStack.readFromPacket((FriendlyByteBuf)buffer);
            return new MaterialMeltingRecipe(id, inputId, temperature, output);
        }

        protected void toNetworkSafe(FriendlyByteBuf buffer, MaterialMeltingRecipe recipe) {
            buffer.m_130070_(recipe.input.getVariant().toString());
            buffer.writeInt(recipe.temperature);
            recipe.result.writeToPacket(buffer);
        }
    }
}

