/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;

public class TagPredicate
implements Predicate<CompoundTag> {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final TagPredicate ANY = new TagPredicate(null);
    @Nullable
    private final CompoundTag tag;

    @Override
    public boolean test(@Nullable CompoundTag toTest) {
        return NbtUtils.m_129235_((Tag)this.tag, (Tag)toTest, (boolean)true);
    }

    public JsonElement serialize() {
        if (this.tag == null) {
            return JsonNull.INSTANCE;
        }
        return new JsonPrimitive(this.tag.toString());
    }

    public void write(FriendlyByteBuf buffer) {
        if (this.tag != null) {
            buffer.writeBoolean(true);
            buffer.m_130079_(this.tag);
        } else {
            buffer.writeBoolean(false);
        }
    }

    public static TagPredicate deserialize(JsonElement element) {
        if (!element.isJsonNull()) {
            try {
                CompoundTag nbt = element.isJsonObject() ? TagParser.m_129359_((String)GSON.toJson(element)) : TagParser.m_129359_((String)GsonHelper.m_13805_((JsonElement)element, (String)"predicate"));
                return new TagPredicate(nbt);
            }
            catch (CommandSyntaxException ex) {
                throw new JsonSyntaxException("Invalid nbt tag: ", (Throwable)ex);
            }
        }
        return ANY;
    }

    public static TagPredicate read(FriendlyByteBuf buffer) {
        CompoundTag tag = null;
        if (buffer.readBoolean()) {
            tag = buffer.m_130260_();
        }
        return new TagPredicate(tag);
    }

    public TagPredicate(@Nullable CompoundTag tag) {
        this.tag = tag;
    }
}

