/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.spilling.effects;

import com.google.gson.JsonDeserializer;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.spilling.ISpillingEffect;
import slimeknights.tconstruct.library.recipe.TagPredicate;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.utils.JsonUtils;

public record PotionFluidEffect(float effectScale, TagPredicate predicate) implements ISpillingEffect
{
    public static final ResourceLocation ID = TConstruct.getResource("potion_fluid");
    public static final JsonDeserializer<PotionFluidEffect> LOADER = (element, type, context) -> {
        JsonObject json = element.getAsJsonObject();
        float scale = GsonHelper.m_13915_((JsonObject)json, (String)"scale");
        TagPredicate predicate = TagPredicate.ANY;
        if (json.has("predicate")) {
            predicate = TagPredicate.deserialize(json.get("predicate"));
        }
        return new PotionFluidEffect(scale, predicate);
    };

    @Override
    public void applyEffects(FluidStack fluid, float scale, ToolAttackContext context) {
        Potion potion;
        LivingEntity target = context.getLivingTarget();
        LivingEntity attacker = context.getAttacker();
        if (target != null && this.predicate.test(fluid.getTag()) && (potion = PotionUtils.m_43577_((CompoundTag)fluid.getTag())) != Potions.f_43598_) {
            int oldInvulnerableTime = target.f_19802_;
            float totalScale = scale * this.effectScale;
            for (MobEffectInstance instance : potion.m_43488_()) {
                MobEffect effect = instance.m_19544_();
                if (effect.m_8093_()) {
                    target.f_19802_ = 0;
                    effect.m_19461_((Entity)attacker, (Entity)attacker, target, instance.m_19564_(), (double)totalScale);
                    continue;
                }
                int duration = (int)((float)instance.m_19557_() * totalScale);
                if (duration <= 10) continue;
                target.m_7292_(new MobEffectInstance(effect, duration, instance.m_19564_(), instance.m_19571_(), instance.m_19572_(), instance.m_19575_()));
            }
            target.f_19802_ = oldInvulnerableTime;
        }
    }

    public JsonObject serialize(JsonSerializationContext context) {
        JsonObject json = JsonUtils.withType(ID);
        json.addProperty("scale", (Number)Float.valueOf(this.effectScale));
        if (this.predicate != TagPredicate.ANY) {
            json.add("predicate", this.predicate.serialize());
        }
        return json;
    }
}

