/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.data.tinkering;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.data.GenericDataProvider;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.mantle.registration.object.FluidObject;
import slimeknights.tconstruct.library.json.predicate.IJsonPredicate;
import slimeknights.tconstruct.library.json.predicate.entity.LivingEntityPredicate;
import slimeknights.tconstruct.library.modifiers.spilling.ISpillingEffect;
import slimeknights.tconstruct.library.modifiers.spilling.SpillingFluidManager;
import slimeknights.tconstruct.library.modifiers.spilling.effects.ConditionalSpillingEffect;
import slimeknights.tconstruct.library.modifiers.spilling.effects.DamageSpillingEffect;
import slimeknights.tconstruct.library.modifiers.spilling.effects.SetFireSpillingEffect;

public abstract class AbstractSpillingFluidProvider
extends GenericDataProvider {
    private final String modId;
    private final Map<ResourceLocation, Builder> entries = new HashMap<ResourceLocation, Builder>();

    public AbstractSpillingFluidProvider(DataGenerator generator, String modId) {
        super(generator, PackType.SERVER_DATA, "tinkering/spilling", SpillingFluidManager.GSON);
        this.modId = modId;
    }

    protected abstract void addFluids();

    public void m_6865_(HashCache cache) throws IOException {
        this.addFluids();
        this.entries.forEach((id, data) -> this.saveThing(cache, (ResourceLocation)id, data.build()));
    }

    protected Builder addFluid(ResourceLocation id, FluidIngredient fluid) {
        Builder newBuilder = new Builder(fluid);
        Builder original = this.entries.put(id, newBuilder);
        if (original != null) {
            throw new IllegalArgumentException("Duplicate spilling fluid " + id);
        }
        return newBuilder;
    }

    protected Builder addFluid(String name, FluidIngredient fluid) {
        return this.addFluid(new ResourceLocation(this.modId, name), fluid);
    }

    protected Builder addFluid(FluidStack fluid) {
        return this.addFluid(Objects.requireNonNull(fluid.getFluid().getRegistryName()).m_135815_(), FluidIngredient.of((FluidStack)fluid));
    }

    protected Builder addFluid(Fluid fluid, int amount) {
        return this.addFluid(Objects.requireNonNull(fluid.getRegistryName()).m_135815_(), FluidIngredient.of((Fluid)fluid, (int)amount));
    }

    protected Builder addFluid(String name, TagKey<Fluid> fluid, int amount) {
        return this.addFluid(name, FluidIngredient.of(fluid, (int)amount));
    }

    protected Builder addFluid(TagKey<Fluid> fluid, int amount) {
        return this.addFluid(fluid.f_203868_().m_135815_(), fluid, amount);
    }

    protected Builder addFluid(FluidObject<?> fluid, boolean forgeTag, int amount) {
        return this.addFluid((TagKey<Fluid>)(forgeTag ? fluid.getForgeTag() : fluid.getLocalTag()), amount);
    }

    protected Builder burningFluid(TagKey<Fluid> tag, float damage, int time) {
        return this.burningFluid(tag.f_203868_().m_135815_(), tag, 10, damage, time);
    }

    protected Builder burningFluid(String name, TagKey<Fluid> tag, int amount, float damage, int time) {
        return this.addFluid(name, tag, amount).addEffect(LivingEntityPredicate.FIRE_IMMUNE.inverted(), new DamageSpillingEffect(DamageSpillingEffect.DamageType.FIRE, damage)).addEffect(new SetFireSpillingEffect(time));
    }

    protected static class Builder {
        private ICondition condition = null;
        private final FluidIngredient ingredient;
        private final ImmutableList.Builder<ISpillingEffect> effects = ImmutableList.builder();

        public Builder addEffect(ISpillingEffect effect) {
            this.effects.add((Object)effect);
            return this;
        }

        public Builder addEffect(IJsonPredicate<LivingEntity> predicate, ISpillingEffect effect) {
            return this.addEffect(new ConditionalSpillingEffect(predicate, effect));
        }

        private SpillingFluidJson build() {
            ImmutableList effects = this.effects.build();
            if (effects.isEmpty()) {
                throw new IllegalStateException("Must have at least 1 effect");
            }
            return new SpillingFluidJson(this.condition, this.ingredient, (List<ISpillingEffect>)effects);
        }

        public Builder(FluidIngredient ingredient) {
            this.ingredient = ingredient;
        }

        public Builder condition(ICondition condition) {
            this.condition = condition;
            return this;
        }
    }

    private static class SpillingFluidJson {
        @Nullable
        private final ICondition condition;
        private final FluidIngredient fluid;
        private final List<ISpillingEffect> effects;

        public SpillingFluidJson(@Nullable ICondition condition, FluidIngredient fluid, List<ISpillingEffect> effects) {
            this.condition = condition;
            this.fluid = fluid;
            this.effects = effects;
        }
    }
}

