/*
 * Decompiled with CFR 0.152.
 */
package fuzs.airhop.handler;

import fuzs.airhop.AirHop;
import fuzs.airhop.capability.AirHopsCapability;
import fuzs.airhop.config.ServerConfig;
import fuzs.airhop.registry.ModRegistry;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class PlayerFallHandler {
    @SubscribeEvent
    public void onPlayerTick$start(TickEvent.PlayerTickEvent evt) {
        if (evt.phase != TickEvent.Phase.START) {
            return;
        }
        if (evt.player.m_20096_() && evt.player.m_20184_().m_7098_() <= 0.0) {
            evt.player.getCapability(ModRegistry.AIR_HOPS_CAPABILITY).ifPresent(AirHopsCapability::resetAirHops);
        }
    }

    @SubscribeEvent
    public void onLivingFall(LivingFallEvent evt) {
        LivingEntity livingEntity = evt.getEntityLiving();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            evt.setDistance(this.onGroundHit(player, evt.getDistance()));
        }
    }

    private float onGroundHit(Player player, float fallDistance) {
        LazyOptional optional = player.getCapability(ModRegistry.AIR_HOPS_CAPABILITY);
        if (optional.isPresent()) {
            int airHops = ((AirHopsCapability)optional.orElseThrow(IllegalStateException::new)).getAirHops();
            if (!((ServerConfig)AirHop.CONFIG.server()).fallDamage && airHops > 0) {
                return Math.max(0.0f, fallDistance - (float)airHops * PlayerFallHandler.getJumpHeight(player));
            }
        }
        return fallDistance;
    }

    public static float getJumpHeight(Player player) {
        float jumpHeight = 1.25f;
        if (player.m_21023_(MobEffects.f_19603_)) {
            jumpHeight += 0.6875f * ((float)player.m_21124_(MobEffects.f_19603_).m_19564_() + 1.0f);
        }
        return jumpHeight;
    }
}

