/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.inventorysorter;

import com.google.common.collect.ImmutableBiMap;
import cpw.mods.inventorysorter.ContainerContext;
import cpw.mods.inventorysorter.InventoryHandler;
import cpw.mods.inventorysorter.InventorySorter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public enum ScrollWheelHandler implements Consumer<ContainerContext>
{
    ONEITEMIN(-1),
    ONEITEMOUT(1);

    private final int moveAmount;

    private ScrollWheelHandler(int amount) {
        this.moveAmount = amount;
    }

    @Override
    @Nullable
    public void accept(ContainerContext context) {
        Slot source;
        if (context == null) {
            throw new NullPointerException("WHUT");
        }
        if (context.slotMapping == null) {
            return;
        }
        ItemStack is = InventoryHandler.INSTANCE.getItemStack(context);
        if (is == null) {
            return;
        }
        ImmutableBiMap<Container, InventoryHandler.InventoryMapping> mapping = context.mapping;
        if (this.moveAmount < 0 && is.m_41741_() > is.m_41613_()) {
            source = InventoryHandler.INSTANCE.findStackWithItem(is, context);
        } else if (this.moveAmount > 0) {
            source = context.slot;
        } else {
            return;
        }
        if (source == null) {
            return;
        }
        if (InventorySorter.INSTANCE.slotblacklist.contains(source.getClass().getName())) {
            return;
        }
        if (InventorySorter.INSTANCE.slotblacklist.contains(context.slot.getClass().getName())) {
            return;
        }
        if (!source.m_8010_((Player)context.player)) {
            return;
        }
        if (!source.m_5857_(is)) {
            return;
        }
        ItemStack sourceStack = InventoryHandler.INSTANCE.getItemStack(source);
        if (sourceStack.m_41619_()) {
            return;
        }
        ItemStack iscopy = sourceStack.m_41777_();
        iscopy.m_41764_(1);
        ArrayList<InventoryHandler.InventoryMapping> mappingCandidates = new ArrayList<InventoryHandler.InventoryMapping>();
        if (this.moveAmount < 0) {
            InventoryHandler.InventoryMapping inventoryMapping = new InventoryHandler.InventoryMapping(context.slot.f_40218_, context.player.f_36096_, context.slot.f_40218_, context.slot.getClass());
            mappingCandidates.add(inventoryMapping);
            inventoryMapping.begin = context.slot.f_40219_;
            inventoryMapping.end = context.slot.f_40219_;
        } else if (context.player.f_36096_ == context.player.f_36095_) {
            if (InventoryHandler.preferredOrders.containsKey(context.slotMapping.inv)) {
                mappingCandidates.addAll(InventoryHandler.preferredOrders.get(context.slotMapping.inv).stream().map(arg_0 -> mapping.get(arg_0)).collect(Collectors.toList()));
            }
            Collections.reverse(mappingCandidates);
        } else {
            for (Map.Entry<Container, InventoryHandler.InventoryMapping> entry : InventoryHandler.INSTANCE.getSortedMapping(context)) {
                if (entry.getValue().proxy == context.slot.f_40218_ || InventorySorter.INSTANCE.slotblacklist.contains(entry.getValue().slotType.getName())) continue;
                mappingCandidates.add(entry.getValue());
            }
        }
        Collections.reverse(mappingCandidates);
        for (InventoryHandler.InventoryMapping mappingCandidate : mappingCandidates) {
            if (mappingCandidate.inv == ContainerContext.PLAYER_OFFHAND && this.moveAmount > 0) {
                boolean empty = true;
                for (ItemStack itemStack : context.player.m_150109_().f_35976_) {
                    if (itemStack.m_41619_()) continue;
                    empty = false;
                }
                if (empty) continue;
            }
            if (mappingCandidate.inv == ContainerContext.PLAYER_HOTBAR && this.moveAmount > 0) {
                boolean hasTarget = false;
                boolean found = false;
                for (int i = 0; i < 9; ++i) {
                    ItemStack itemStack = (ItemStack)context.player.m_150109_().f_35974_.get(i);
                    if (ItemStack.m_41746_((ItemStack)itemStack, (ItemStack)sourceStack) && itemStack.m_41613_() < itemStack.m_41741_()) {
                        hasTarget = true;
                        continue;
                    }
                    if (!ItemStack.m_41746_((ItemStack)itemStack, (ItemStack)sourceStack)) continue;
                    found = true;
                }
                if (!hasTarget && found) continue;
            }
            InventoryHandler.INSTANCE.moveItemToOtherInventory(context, iscopy, mappingCandidate.begin, mappingCandidate.end + 1, this.moveAmount < 0);
            if (iscopy.m_41613_() != 0) continue;
            sourceStack.m_41769_(-1);
            if (sourceStack.m_41613_() == 0) {
                source.m_5852_(ItemStack.f_41583_);
                break;
            }
            source.m_6654_();
            break;
        }
    }
}

