/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.inventorysorter;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import cpw.mods.inventorysorter.Config;
import cpw.mods.inventorysorter.InventorySorterCommand;
import cpw.mods.inventorysorter.KeyHandler;
import cpw.mods.inventorysorter.Network;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="inventorysorter")
public class InventorySorter {
    public static InventorySorter INSTANCE;
    static final Logger LOGGER;
    ResourceLocation lastContainerType;
    boolean debugLog;
    final Set<String> slotblacklist = new HashSet<String>();
    final Set<ResourceLocation> containerblacklist = new HashSet<ResourceLocation>();
    boolean configLoaded = false;

    public InventorySorter() {
        INSTANCE = this;
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::preinit);
        bus.addListener(this::clientSetup);
        bus.addListener(this::handleimc);
        bus.addListener(this::onConfigLoad);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.SPEC);
        MinecraftForge.EVENT_BUS.addListener(this::onServerStarting);
    }

    private void clientSetup(FMLClientSetupEvent evt) {
        KeyHandler.init();
    }

    private void handleimc(InterModProcessEvent evt) {
        Stream imc = InterModComms.getMessages((String)"inventorysorter");
        imc.forEach(this::handleimcmessage);
    }

    private void handleimcmessage(InterModComms.IMCMessage msg) {
        ResourceLocation slotContainerTarget;
        String slotBlacklistTarget;
        if ("slotblacklist".equals(msg.getMethod()) && this.slotblacklist.add(slotBlacklistTarget = (String)msg.getMessageSupplier().get())) {
            this.debugLog("SlotBlacklist added {}", () -> new String[]{slotBlacklistTarget});
        }
        if ("containerblacklist".equals(msg.getMethod()) && this.containerblacklist.add(slotContainerTarget = (ResourceLocation)msg.getMessageSupplier().get())) {
            this.debugLog("ContainerBlacklist added {}", () -> new String[]{slotContainerTarget.toString()});
        }
        this.updateConfig();
    }

    private void updateConfig() {
        if (!this.configLoaded) {
            return;
        }
        Config.CONFIG.containerBlacklist.set(this.containerblacklist.stream().map(Objects::toString).collect(Collectors.toList()));
        Config.CONFIG.slotBlacklist.set(new ArrayList<String>(this.slotblacklist));
    }

    private void preinit(FMLCommonSetupEvent evt) {
        Network.init();
    }

    private void onServerStarting(ServerStartingEvent evt) {
        InventorySorterCommand.register((CommandDispatcher<CommandSourceStack>)evt.getServer().m_129892_().m_82094_());
    }

    void onConfigLoad(ModConfigEvent configEvent) {
        this.slotblacklist.clear();
        this.slotblacklist.addAll((Collection)Config.CONFIG.slotBlacklist.get());
        this.containerblacklist.clear();
        this.containerblacklist.addAll(((List)Config.CONFIG.containerBlacklist.get()).stream().map(ResourceLocation::new).collect(Collectors.toSet()));
    }

    boolean wheelModConflicts() {
        return ModList.get().isLoaded("mousetweaks");
    }

    boolean sortingModConflicts() {
        return false;
    }

    final void debugLog(String message, Supplier<String[]> args) {
        if (this.debugLog) {
            LOGGER.error(message, (Object[])args.get());
        }
    }

    private static TextComponent greenText(String string) {
        TextComponent tcs = new TextComponent(string);
        tcs.m_7383_().m_131140_(ChatFormatting.GREEN);
        return tcs;
    }

    static int blackListAdd(CommandContext<CommandSourceStack> context) {
        ResourceLocation containerType = InventorySorterCommand.Arguments.CONTAINER.get(context);
        if (ForgeRegistries.CONTAINERS.containsKey(containerType)) {
            InventorySorter.INSTANCE.containerblacklist.add(containerType);
            INSTANCE.updateConfig();
            ((CommandSourceStack)context.getSource()).m_81354_((Component)new TranslatableComponent("inventorysorter.commands.inventorysorter.bladd.message", new Object[]{containerType}), true);
            return 1;
        }
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TranslatableComponent("inventorysorter.commands.inventorysorter.badtype", new Object[]{containerType}), true);
        return 0;
    }

    static int blackListRemove(CommandContext<CommandSourceStack> context) {
        ResourceLocation containerType = InventorySorterCommand.Arguments.BLACKLISTED.get(context);
        if (ForgeRegistries.CONTAINERS.containsKey(containerType) && InventorySorter.INSTANCE.containerblacklist.remove(containerType)) {
            INSTANCE.updateConfig();
            ((CommandSourceStack)context.getSource()).m_81354_((Component)new TranslatableComponent("inventorysorter.commands.inventorysorter.blremove.message", new Object[]{containerType}), true);
            return 1;
        }
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TranslatableComponent("inventorysorter.commands.inventorysorter.badtype", new Object[]{containerType}), true);
        return 0;
    }

    static int showLast(CommandContext<CommandSourceStack> context) {
        if (InventorySorter.INSTANCE.lastContainerType != null) {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)new TranslatableComponent("inventorysorter.commands.inventorysorter.showlast.message", new Object[]{InventorySorter.INSTANCE.lastContainerType}), true);
        } else {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)new TranslatableComponent("inventorysorter.commands.inventorysorter.showlast.nosort"), true);
        }
        return 0;
    }

    static int showBlacklist(CommandContext<CommandSourceStack> context) {
        if (InventorySorter.INSTANCE.containerblacklist.isEmpty()) {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)new TranslatableComponent("inventorysorter.commands.inventorysorter.showblacklist.empty"), true);
        } else {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)new TranslatableComponent("inventorysorter.commands.inventorysorter.showblacklist.message", new Object[]{InventorySorter.listBlacklist().collect(Collectors.toList())}), true);
        }
        return 0;
    }

    static Stream<String> listContainers() {
        return ForgeRegistries.CONTAINERS.getEntries().stream().map(e -> ((ResourceKey)e.getKey()).toString());
    }

    static Stream<String> listBlacklist() {
        return InventorySorter.INSTANCE.containerblacklist.stream().map(Object::toString);
    }

    static {
        LOGGER = LogManager.getLogger();
    }
}

