/*
 * Decompiled with CFR 0.152.
 */
package appeng.worldgen.meteorite;

import appeng.server.services.compass.CompassService;
import appeng.worldgen.meteorite.CraterType;
import appeng.worldgen.meteorite.MeteoritePlacer;
import appeng.worldgen.meteorite.PlacedMeteoriteSettings;
import appeng.worldgen.meteorite.fallout.FalloutMode;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;

public class MeteoriteStructurePiece
extends StructurePiece {
    public static final StructurePieceType TYPE = StructurePieceType.m_210152_(MeteoriteStructurePiece::new, (String)"ae2mtrt");
    private final PlacedMeteoriteSettings settings;

    public static void register() {
    }

    protected MeteoriteStructurePiece(BlockPos center, float coreRadius, CraterType craterType, FalloutMode fallout, boolean pureCrater, boolean craterLake) {
        super(TYPE, 0, MeteoriteStructurePiece.createBoundingBox(center));
        this.settings = new PlacedMeteoriteSettings(center, coreRadius, craterType, fallout, pureCrater, craterLake);
    }

    private static BoundingBox createBoundingBox(BlockPos origin) {
        int range = 64;
        ChunkPos chunkPos = new ChunkPos(origin);
        return new BoundingBox(chunkPos.m_45604_() - range, origin.m_123342_(), chunkPos.m_45605_() - range, chunkPos.m_45608_() + range, origin.m_123342_(), chunkPos.m_45609_() + range);
    }

    public MeteoriteStructurePiece(CompoundTag tag) {
        super(TYPE, tag);
        BlockPos center = BlockPos.m_122022_((long)tag.m_128454_("c"));
        float coreRadius = tag.m_128457_("r");
        CraterType craterType = CraterType.values()[tag.m_128445_("t")];
        FalloutMode fallout = FalloutMode.values()[tag.m_128445_("f")];
        boolean pureCrater = tag.m_128471_("p");
        boolean craterLake = tag.m_128471_("l");
        this.settings = new PlacedMeteoriteSettings(center, coreRadius, craterType, fallout, pureCrater, craterLake);
    }

    public boolean isFinalized() {
        return this.settings.getCraterType() != null;
    }

    public PlacedMeteoriteSettings getSettings() {
        return this.settings;
    }

    protected void m_183620_(StructurePieceSerializationContext context, CompoundTag tag) {
        tag.m_128350_("r", this.settings.getMeteoriteRadius());
        tag.m_128356_("c", this.settings.getPos().m_121878_());
        tag.m_128344_("t", (byte)this.settings.getCraterType().ordinal());
        tag.m_128344_("f", (byte)this.settings.getFallout().ordinal());
        tag.m_128379_("p", this.settings.isPureCrater());
        tag.m_128379_("l", this.settings.isCraterLake());
    }

    public void m_183269_(WorldGenLevel level, StructureFeatureManager featureManager, ChunkGenerator chunkGeneratorIn, Random rand, BoundingBox bounds, ChunkPos chunkPos, BlockPos centerPos) {
        MeteoritePlacer placer = new MeteoritePlacer((LevelAccessor)level, this.settings, bounds, rand);
        placer.place();
        CompassService.updateArea(level.m_6018_(), level.m_6325_(chunkPos.f_45578_, chunkPos.f_45579_));
    }
}

