/*
 * Decompiled with CFR 0.152.
 */
package appeng.thirdparty.codechicken.lib.model.pipeline.transformers;

import appeng.thirdparty.codechicken.lib.model.Quad;
import appeng.thirdparty.codechicken.lib.model.pipeline.IPipelineElementFactory;
import appeng.thirdparty.codechicken.lib.model.pipeline.QuadTransformer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector4f;
import net.minecraft.core.Direction;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;

public class QuadMatrixTransformer
extends QuadTransformer {
    public static IPipelineElementFactory<QuadMatrixTransformer> FACTORY = QuadMatrixTransformer::new;
    private static final Matrix4f identity = new Matrix4f();
    private final Vector4f storage = new Vector4f();
    private Matrix4f matrix;
    private boolean identityMatrix;

    QuadMatrixTransformer() {
    }

    public QuadMatrixTransformer(IVertexConsumer parent, Matrix4f matrix) {
        super(parent);
        this.matrix = matrix;
        this.identityMatrix = matrix.equals((Object)identity);
    }

    public void setMatrix(Matrix4f matrix) {
        this.matrix = matrix;
        this.identityMatrix = matrix.equals((Object)identity);
    }

    @Override
    public boolean transform() {
        if (this.identityMatrix) {
            return true;
        }
        for (Quad.Vertex vertex : this.quad.vertices) {
            this.storage.m_123602_(vertex.vec[0], vertex.vec[1], vertex.vec[2], 1.0f);
            this.storage.m_123607_(this.matrix);
            vertex.vec[0] = this.storage.m_123601_();
            vertex.vec[1] = this.storage.m_123615_();
            vertex.vec[2] = this.storage.m_123616_();
            this.storage.m_123602_(vertex.normal[0], vertex.normal[1], vertex.normal[2], 0.0f);
            this.storage.m_123607_(this.matrix);
            this.storage.m_123618_();
            vertex.normal[0] = this.storage.m_123601_();
            vertex.normal[1] = this.storage.m_123615_();
            vertex.normal[2] = this.storage.m_123616_();
        }
        Quad.Vertex v0 = this.quad.vertices[0];
        this.quad.orientation = Direction.m_122372_((float)v0.normal[0], (float)v0.normal[1], (float)v0.normal[2]);
        return true;
    }

    static {
        identity.m_27624_();
    }
}

