/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.subcommands;

import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.server.ISubCommand;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ChunkLogger
implements ISubCommand {
    private boolean enabled = false;

    private void displayStack() {
        if (AEConfig.instance().isChunkLoggerTraceEnabled()) {
            boolean output = false;
            for (StackTraceElement e : Thread.currentThread().getStackTrace()) {
                if (output) {
                    AELog.info("\t\t" + e.getClassName() + "." + e.getMethodName() + " (" + e.getLineNumber() + ")", new Object[0]);
                    continue;
                }
                output = e.getClassName().contains("EventBus") && e.getMethodName().contains("post");
            }
        }
    }

    @SubscribeEvent
    public void onChunkLoadEvent(ChunkEvent.Load event) {
        if (!event.getWorld().m_5776_()) {
            AELog.info("Chunk Loaded:   " + event.getChunk().m_7697_().f_45578_ + ", " + event.getChunk().m_7697_().f_45579_, new Object[0]);
            this.displayStack();
        }
    }

    @SubscribeEvent
    public void onChunkUnloadEvent(ChunkEvent.Unload unload) {
        if (!unload.getWorld().m_5776_()) {
            AELog.info("Chunk Unloaded: " + unload.getChunk().m_7697_().f_45578_ + ", " + unload.getChunk().m_7697_().f_45579_, new Object[0]);
            this.displayStack();
        }
    }

    @Override
    public void call(MinecraftServer srv, CommandContext<CommandSourceStack> data, CommandSourceStack sender) {
        boolean bl = this.enabled = !this.enabled;
        if (this.enabled) {
            MinecraftForge.EVENT_BUS.register((Object)this);
            sender.m_81354_((Component)new TranslatableComponent("commands.ae2.ChunkLoggerOn"), true);
        } else {
            MinecraftForge.EVENT_BUS.unregister((Object)this);
            sender.m_81354_((Component)new TranslatableComponent("commands.ae2.ChunkLoggerOff"), true);
        }
    }
}

