/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts;

import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartItem;
import appeng.api.parts.PartHelper;
import appeng.core.AELog;
import appeng.core.definitions.AEBlocks;
import appeng.util.Platform;
import appeng.util.SettingsFrom;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PartPlacement {
    public static InteractionResult place(UseOnContext context) {
        Player player = context.m_43723_();
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        ItemStack partStack = context.m_43722_();
        Direction side = context.m_43719_();
        Item item = partStack.m_41720_();
        if (!(item instanceof IPartItem)) {
            return InteractionResult.PASS;
        }
        IPartItem partItem = (IPartItem)item;
        Placement placement = PartPlacement.getPartPlacement(player, level, partStack, pos, side);
        if (placement == null) {
            return InteractionResult.FAIL;
        }
        Object part = PartPlacement.placePart(player, level, partItem, partStack.m_41783_(), placement.pos(), placement.side());
        if (part == null) {
            Platform.sendImmediateBlockEntityUpdate(player, pos);
            return InteractionResult.FAIL;
        }
        if (!level.f_46443_ && player != null && !player.m_7500_()) {
            partStack.m_41774_(1);
            if (partStack.m_41613_() == 0) {
                player.m_21008_(context.m_43724_(), ItemStack.f_41583_);
            }
        }
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    @Nullable
    public static <T extends IPart> T placePart(@Nullable Player player, Level level, IPartItem<T> partItem, @Nullable CompoundTag configTag, BlockPos pos, Direction side) {
        IPartHost host = PartHelper.getOrPlacePartHost(level, pos, false, player);
        if (host == null) {
            return null;
        }
        T addedPart = host.addPart(partItem, side, player);
        if (addedPart == null) {
            if (host.isEmpty()) {
                host.cleanup();
            }
            return null;
        }
        VoxelShape collisionShape = host.getCollisionShape(null);
        if (!collisionShape.m_83281_() && !level.m_5450_(null, collisionShape.m_83216_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()))) {
            host.removePartInstance((IPart)addedPart);
            if (host.isEmpty()) {
                host.cleanup();
            }
            return null;
        }
        if (configTag != null) {
            try {
                addedPart.importSettings(SettingsFrom.DISMANTLE_ITEM, configTag, player);
            }
            catch (Exception e) {
                AELog.warn(e, "Failed to import part settings during placement.");
            }
        }
        SoundType ss = AEBlocks.CABLE_BUS.block().m_49962_(AEBlocks.CABLE_BUS.block().m_49966_());
        level.m_5594_(null, pos, ss.m_56777_(), SoundSource.BLOCKS, (ss.m_56773_() + 1.0f) / 2.0f, ss.m_56774_() * 0.8f);
        return addedPart;
    }

    @Nullable
    public static Placement getPartPlacement(@Nullable Player player, Level level, ItemStack partStack, BlockPos pos, Direction side) {
        if (PartPlacement.canPlacePartOnBlock(player, level, partStack, pos, side)) {
            return new Placement(pos, side);
        }
        if (PartPlacement.canPlacePartOnBlock(player, level, partStack, pos = pos.m_142300_(side), side = side.m_122424_())) {
            return new Placement(pos, side);
        }
        return null;
    }

    public static boolean canPlacePartOnBlock(@Nullable Player player, Level level, ItemStack partStack, BlockPos pos, Direction side) {
        IPartHost host = PartHelper.getPartHost(level, pos);
        if (host == null && !PartHelper.canPlacePartHost(player, level, pos)) {
            return false;
        }
        return host == null || host.canAddPart(partStack, side);
    }

    public record Placement(BlockPos pos, Direction side) {
    }
}

