/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu.me.interaction;

import appeng.api.behaviors.ContainerItemStrategy;
import appeng.api.config.Actionable;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.GenericStack;
import appeng.helpers.FluidContainerHelper;
import appeng.util.fluid.FluidSoundHelper;
import com.google.common.primitives.Ints;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class FluidContainerItemStrategy
implements ContainerItemStrategy<AEFluidKey, Context> {
    @Override
    @Nullable
    public GenericStack getContainedStack(ItemStack stack) {
        return FluidContainerHelper.getContainedStack(stack);
    }

    @Override
    @Nullable
    public Context findCarriedContext(Player player, AbstractContainerMenu menu) {
        if (menu.m_142621_().getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent()) {
            return new Context(player, menu);
        }
        return null;
    }

    @Override
    public long extract(Context context, AEFluidKey what, long amount, Actionable mode) {
        ItemStack held = context.menu.m_142621_();
        ItemStack copy = ItemHandlerHelper.copyStackWithSize((ItemStack)held, (int)1);
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)copy.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).orElse(null);
        if (fluidHandler == null) {
            return 0L;
        }
        int extracted = fluidHandler.drain(what.toStack(Ints.saturatedCast((long)amount)), mode.getFluidAction()).getAmount();
        if (mode == Actionable.MODULATE) {
            held.m_41774_(1);
            if (held.m_41619_()) {
                context.menu.m_142503_(fluidHandler.getContainer());
            } else {
                context.player.m_150109_().m_150079_(fluidHandler.getContainer());
            }
        }
        return extracted;
    }

    @Override
    public long insert(Context context, AEFluidKey what, long amount, Actionable mode) {
        ItemStack held = context.menu.m_142621_();
        ItemStack copy = ItemHandlerHelper.copyStackWithSize((ItemStack)held, (int)1);
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)copy.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).orElse(null);
        if (fluidHandler == null) {
            return 0L;
        }
        int filled = fluidHandler.fill(what.toStack(Ints.saturatedCast((long)amount)), mode.getFluidAction());
        if (mode == Actionable.MODULATE) {
            held.m_41774_(1);
            if (held.m_41619_()) {
                context.menu.m_142503_(fluidHandler.getContainer());
            } else {
                context.player.m_150109_().m_150079_(fluidHandler.getContainer());
            }
        }
        return filled;
    }

    @Override
    public void playFillSound(Player player, AEFluidKey what) {
        FluidSoundHelper.playFillSound(player, what);
    }

    @Override
    public void playEmptySound(Player player, AEFluidKey what) {
        FluidSoundHelper.playEmptySound(player, what);
    }

    @Override
    @Nullable
    public GenericStack getExtractableContent(Context context) {
        return this.getContainedStack(context.menu.m_142621_());
    }

    static class Context {
        private final Player player;
        private final AbstractContainerMenu menu;

        private Context(Player player, AbstractContainerMenu menu) {
            this.player = player;
            this.menu = menu;
        }
    }
}

