/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu;

import appeng.core.AELog;
import appeng.menu.AEBaseMenu;
import appeng.menu.locator.MenuLocator;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;

public final class MenuOpener {
    private static final Map<MenuType<? extends AEBaseMenu>, Opener> registry = new HashMap<MenuType<? extends AEBaseMenu>, Opener>();

    private MenuOpener() {
    }

    public static <T extends AEBaseMenu> void addOpener(MenuType<T> type, Opener opener) {
        registry.put(type, opener);
    }

    public static boolean open(MenuType<?> type, Player player, MenuLocator locator) {
        Preconditions.checkArgument((!player.m_183503_().m_5776_() ? 1 : 0) != 0, (Object)"Menus must be opened on the server.");
        Opener opener = registry.get(type);
        if (opener == null) {
            AELog.warn("Trying to open menu for unknown menu type {}", type);
            return false;
        }
        return opener.open(player, locator);
    }

    @FunctionalInterface
    public static interface Opener {
        public boolean open(Player var1, MenuLocator var2);
    }
}

