/*
 * Decompiled with CFR 0.152.
 */
package appeng.loot;

import appeng.core.AELog;
import appeng.core.AppEng;
import appeng.loot.NeededPressType;
import appeng.loot.NeedsPressConditionSerializer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.CriterionProgress;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public record NeedsPressCondition(NeededPressType needed) implements LootItemCondition
{
    public static final LootItemConditionType TYPE = new LootItemConditionType((Serializer)new NeedsPressConditionSerializer());
    public static final ResourceLocation ADVANCEMENT_ID = AppEng.makeId("main/presses");

    public LootItemConditionType m_7940_() {
        return TYPE;
    }

    public NeededPressType getNeeded() {
        return this.needed;
    }

    public boolean test(LootContext lootContext) {
        Entity player = (Entity)lootContext.m_78953_(LootContextParams.f_81455_);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Advancement advancement = serverPlayer.m_20194_().m_129889_().m_136041_(ADVANCEMENT_ID);
            if (advancement == null) {
                AELog.warn("Missing advancement %s", ADVANCEMENT_ID);
                return false;
            }
            AdvancementProgress progress = serverPlayer.m_8960_().m_135996_(advancement);
            if (progress.m_8193_()) {
                return false;
            }
            CriterionProgress criterion = progress.m_8214_(this.needed.getCriterionName());
            if (criterion == null) {
                AELog.warn("Missing criterion %s in advancement %s", this.needed.getCriterionName(), advancement);
                return false;
            }
            return !criterion.m_12911_();
        }
        return false;
    }
}

