/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.waila.tile;

import appeng.api.networking.energy.IAEPowerStorage;
import appeng.core.localization.InGameTooltip;
import appeng.integration.modules.waila.BaseDataProvider;
import appeng.util.Platform;
import mcp.mobius.waila.api.BlockAccessor;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.config.IPluginConfig;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public final class PowerStorageDataProvider
extends BaseDataProvider {
    private static final String TAG_CURRENT_POWER = "currentPower";
    private static final String TAG_MAX_POWER = "maxPower";

    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        CompoundTag tag = accessor.getServerData();
        if (tag.m_128425_(TAG_MAX_POWER, 6)) {
            double currentPower = tag.m_128459_(TAG_CURRENT_POWER);
            double maxPower = tag.m_128459_(TAG_MAX_POWER);
            String formatCurrentPower = Platform.formatPower(currentPower, false);
            String formatMaxPower = Platform.formatPower(maxPower, false);
            tooltip.add((Component)InGameTooltip.Stored.text(formatCurrentPower, formatMaxPower));
        }
    }

    @Override
    public void appendServerData(CompoundTag tag, ServerPlayer player, Level level, BlockEntity blockEntity, boolean showDetails) {
        IAEPowerStorage storage;
        if (blockEntity instanceof IAEPowerStorage && (storage = (IAEPowerStorage)blockEntity).getAEMaxPower() > 0.0) {
            tag.m_128347_(TAG_CURRENT_POWER, storage.getAECurrentPower());
            tag.m_128347_(TAG_MAX_POWER, storage.getAEMaxPower());
        }
    }
}

