/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.jei.transfer;

import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.core.localization.ItemModText;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.InventoryActionPacket;
import appeng.helpers.InventoryAction;
import appeng.integration.abstraction.JEIFacade;
import appeng.integration.modules.jei.GenericEntryStackHelper;
import appeng.integration.modules.jei.transfer.AbstractTransferHandler;
import appeng.menu.me.common.GridInventoryEntry;
import appeng.menu.me.common.MEStorageMenu;
import appeng.menu.me.items.PatternEncodingTermMenu;
import appeng.menu.slot.FakeSlot;
import appeng.parts.encoding.EncodingMode;
import appeng.util.CraftingRecipeUtil;
import com.google.common.math.LongMath;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiIngredient;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.runtime.IIngredientVisibility;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class EncodePatternTransferHandler<T extends PatternEncodingTermMenu>
extends AbstractTransferHandler
implements IRecipeTransferHandler<T, Object> {
    private static final int CRAFTING_GRID_WIDTH = 3;
    private static final int CRAFTING_GRID_HEIGHT = 3;
    private static final Comparator<GridInventoryEntry> ENTRY_COMPARATOR = Comparator.comparing(GridInventoryEntry::isCraftable).thenComparing(EncodePatternTransferHandler::isUndamaged).thenComparing(GridInventoryEntry::getStoredAmount);
    private final Class<T> containerClass;
    private final IRecipeTransferHandlerHelper helper;
    @Nullable
    private IIngredientVisibility ingredientVisibility;

    private static Boolean isUndamaged(GridInventoryEntry entry) {
        AEItemKey itemKey;
        AEKey aEKey = entry.getWhat();
        return !(aEKey instanceof AEItemKey) || !(itemKey = (AEItemKey)aEKey).isDamaged();
    }

    public EncodePatternTransferHandler(Class<T> containerClass, IRecipeTransferHandlerHelper helper) {
        this.containerClass = containerClass;
        this.helper = helper;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(T menu, Object recipeBase, IRecipeLayout recipeLayout, Player player, boolean maxTransfer, boolean doTransfer) {
        boolean craftingRecipe;
        Recipe recipe = null;
        if (recipeBase instanceof Recipe) {
            recipe = (Recipe)recipeBase;
        }
        if ((craftingRecipe = this.isCraftingRecipe(recipe, recipeLayout)) && !this.fitsIn3x3Grid(recipe, recipeLayout)) {
            return this.helper.createUserErrorWithTooltip((Component)ItemModText.RECIPE_TOO_LARGE.text());
        }
        if (doTransfer) {
            if (craftingRecipe) {
                ((PatternEncodingTermMenu)menu).setMode(EncodingMode.CRAFTING);
                this.encodeCraftingRecipe(menu, recipe, this.getGuiIngredientsForCrafting(recipeLayout));
            } else {
                ((PatternEncodingTermMenu)menu).setMode(EncodingMode.PROCESSING);
                this.encodeProcessingRecipe(menu, GenericEntryStackHelper.ofInputs(recipeLayout), GenericEntryStackHelper.ofOutputs(recipeLayout));
            }
        }
        return null;
    }

    private List<List<GenericStack>> getGuiIngredientsForCrafting(IRecipeLayout recipeLayout) {
        ArrayList<List<GenericStack>> result = new ArrayList<List<GenericStack>>(9);
        for (int i = 0; i < 9; ++i) {
            ArrayList<GenericStack> stacks = new ArrayList<GenericStack>();
            IGuiIngredient guiIngredient = (IGuiIngredient)recipeLayout.getItemStacks().getGuiIngredients().get(i);
            if (guiIngredient != null) {
                for (ItemStack stack : guiIngredient.getAllIngredients()) {
                    stacks.add(GenericStack.fromItemStack(stack));
                }
            }
            result.add(stacks);
        }
        return result;
    }

    private void encodeProcessingRecipe(T menu, List<List<GenericStack>> genericIngredients, List<GenericStack> genericResults) {
        Map<AEKey, Integer> ingredientPriorities = this.getIngredientPriorities((MEStorageMenu)menu, ENTRY_COMPARATOR);
        this.encodeBestMatchingStacksIntoSlots(genericIngredients, ingredientPriorities, ((PatternEncodingTermMenu)menu).getProcessingInputSlots());
        this.encodeBestMatchingStacksIntoSlots(genericResults.stream().map(List::of).toList(), ingredientPriorities, ((PatternEncodingTermMenu)menu).getProcessingOutputSlots());
    }

    private void encodeBestMatchingStacksIntoSlots(List<List<GenericStack>> possibleInputsBySlot, Map<AEKey, Integer> ingredientPriorities, FakeSlot[] slots) {
        ArrayList<GenericStack> encodedInputs = new ArrayList<GenericStack>();
        for (List<GenericStack> genericIngredient : possibleInputsBySlot) {
            if (genericIngredient.isEmpty()) continue;
            this.addOrMerge(encodedInputs, EncodePatternTransferHandler.findBestIngredient(ingredientPriorities, genericIngredient));
        }
        for (int i = 0; i < slots.length; ++i) {
            FakeSlot slot = slots[i];
            ItemStack stack = i < encodedInputs.size() ? GenericStack.wrapInItemStack(encodedInputs.get(i)) : ItemStack.f_41583_;
            NetworkHandler.instance().sendToServer(new InventoryActionPacket(InventoryAction.SET_FILTER, slot.f_40219_, stack));
        }
    }

    private void encodeCraftingRecipe(T menu, @Nullable Recipe<?> recipe, List<List<GenericStack>> genericIngredients) {
        Map<AEKey, Integer> prioritizedNetworkInv = this.getIngredientPriorities((MEStorageMenu)menu, ENTRY_COMPARATOR);
        NonNullList encodedInputs = NonNullList.m_122780_((int)((PatternEncodingTermMenu)menu).getCraftingGridSlots().length, (Object)ItemStack.f_41583_);
        if (recipe != null) {
            if (this.ingredientVisibility == null) {
                this.ingredientVisibility = JEIFacade.instance().getRuntime().getIngredientVisibility();
            }
            NonNullList<Ingredient> ingredients3x3 = CraftingRecipeUtil.ensure3by3CraftingMatrix(recipe);
            for (int slot = 0; slot < ingredients3x3.size(); ++slot) {
                Ingredient ingredient = (Ingredient)ingredients3x3.get(slot);
                if (ingredient.m_43947_()) continue;
                Optional<ItemStack> bestNetworkIngredient = prioritizedNetworkInv.entrySet().stream().filter(ni -> {
                    AEItemKey itemKey;
                    Object patt8230$temp = ni.getKey();
                    return patt8230$temp instanceof AEItemKey && ingredient.test((itemKey = (AEItemKey)patt8230$temp).toStack());
                }).max(Comparator.comparingInt(Map.Entry::getValue)).map(entry -> {
                    ItemStack itemStack;
                    Object patt8426$temp = entry.getKey();
                    if (patt8426$temp instanceof AEItemKey) {
                        AEItemKey itemKey = (AEItemKey)patt8426$temp;
                        itemStack = itemKey.toStack();
                    } else {
                        itemStack = null;
                    }
                    return itemStack;
                });
                ItemStack bestIngredient = bestNetworkIngredient.orElseGet(() -> {
                    for (ItemStack stack : ingredient.m_43908_()) {
                        if (!this.ingredientVisibility.isIngredientVisible((IIngredientType)VanillaTypes.ITEM_STACK, (Object)stack)) continue;
                        return stack;
                    }
                    return ingredient.m_43908_()[0];
                });
                encodedInputs.set(slot, (Object)bestIngredient);
            }
        } else {
            for (int slot = 0; slot < genericIngredients.size(); ++slot) {
                List<GenericStack> genericIngredient = genericIngredients.get(slot);
                if (genericIngredient.isEmpty()) continue;
                AEKey bestIngredient = EncodePatternTransferHandler.findBestIngredient(prioritizedNetworkInv, genericIngredient).what();
                if (bestIngredient instanceof AEItemKey) {
                    AEItemKey itemKey = (AEItemKey)bestIngredient;
                    encodedInputs.set(slot, (Object)itemKey.toStack());
                    continue;
                }
                encodedInputs.set(slot, (Object)GenericStack.wrapInItemStack(bestIngredient, 1L));
            }
        }
        for (int i = 0; i < encodedInputs.size(); ++i) {
            ItemStack encodedInput = (ItemStack)encodedInputs.get(i);
            NetworkHandler.instance().sendToServer(new InventoryActionPacket(InventoryAction.SET_FILTER, ((PatternEncodingTermMenu)menu).getCraftingGridSlots()[i].f_40219_, encodedInput));
        }
        for (FakeSlot outputSlot : ((PatternEncodingTermMenu)menu).getProcessingOutputSlots()) {
            NetworkHandler.instance().sendToServer(new InventoryActionPacket(InventoryAction.SET_FILTER, outputSlot.f_40219_, ItemStack.f_41583_));
        }
    }

    private static GenericStack findBestIngredient(Map<AEKey, Integer> ingredientPriorities, List<GenericStack> possibleIngredients) {
        return possibleIngredients.stream().map(gi -> Pair.of((Object)gi, (Object)ingredientPriorities.getOrDefault(gi.what(), Integer.MIN_VALUE))).max(Comparator.comparingInt(Pair::getRight)).map(Pair::getLeft).orElseThrow();
    }

    private void addOrMerge(List<GenericStack> stacks, GenericStack newStack) {
        for (int i = 0; i < stacks.size(); ++i) {
            GenericStack existingStack = stacks.get(i);
            if (!Objects.equals(existingStack.what(), newStack.what())) continue;
            long newAmount = LongMath.saturatedAdd((long)existingStack.amount(), (long)newStack.amount());
            stacks.set(i, new GenericStack(newStack.what(), newAmount));
            long overflow = newStack.amount() - (newAmount - existingStack.amount());
            if (overflow > 0L) {
                stacks.add(new GenericStack(newStack.what(), overflow));
            }
            return;
        }
        stacks.add(newStack);
    }

    public Class<T> getContainerClass() {
        return this.containerClass;
    }

    public Class<Object> getRecipeClass() {
        return Object.class;
    }
}

