/*
 * Decompiled with CFR 0.152.
 */
package appeng.hooks;

import appeng.api.client.AEStackRendering;
import appeng.api.stacks.AmountFormat;
import appeng.api.stacks.GenericStack;
import appeng.client.gui.me.common.StackSizeRenderer;
import appeng.crafting.pattern.EncodedPatternItem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.item.ItemStack;

public final class ItemRendererHooks {
    private static final ThreadLocal<ItemStack> OVERRIDING_FOR = new ThreadLocal();

    private ItemRendererHooks() {
    }

    public static boolean onRenderGuiItemModel(ItemRenderer renderer, ItemStack stack, int x, int y) {
        if (stack.m_41720_() instanceof EncodedPatternItem) {
            EncodedPatternItem encodedPattern;
            ItemStack output;
            if (OVERRIDING_FOR.get() == stack) {
                return false;
            }
            boolean shiftHeld = Screen.m_96638_();
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (shiftHeld && level != null && !(output = (encodedPattern = (EncodedPatternItem)stack.m_41720_()).getOutput(stack)).m_41619_()) {
                BakedModel realModel = renderer.m_115103_().m_109406_(output);
                ItemRendererHooks.renderInstead(renderer, output, x, y, realModel);
                return true;
            }
            return false;
        }
        GenericStack unwrapped = GenericStack.unwrapItemStack(stack);
        if (unwrapped != null) {
            AEStackRendering.drawInGui(Minecraft.m_91087_(), new PoseStack(), x, y, (int)renderer.f_115093_, unwrapped.what());
            if (unwrapped.amount() > 0L) {
                String amtText = unwrapped.what().formatAmount(unwrapped.amount(), AmountFormat.PREVIEW_REGULAR);
                Font font = Minecraft.m_91087_().f_91062_;
                StackSizeRenderer.renderSizeLabel(font, x, y, amtText, false);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void renderInstead(ItemRenderer renderer, ItemStack stack, int x, int y, BakedModel realModel) {
        OVERRIDING_FOR.set(stack);
        try {
            renderer.m_115127_(stack, x, y, realModel);
        }
        finally {
            OVERRIDING_FOR.remove();
        }
    }
}

