/*
 * Decompiled with CFR 0.152.
 */
package appeng.datagen.providers.loot;

import appeng.core.AppEng;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.datagen.providers.IAE2DataProvider;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.Registry;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class BlockDropProvider
extends BlockLoot
implements IAE2DataProvider {
    private final Map<Block, Function<Block, LootTable.Builder>> overrides = ImmutableMap.builder().put((Object)AEBlocks.MATRIX_FRAME.block(), $ -> LootTable.m_79147_()).put((Object)AEBlocks.QUARTZ_ORE.block(), BlockDropProvider::createQuartzOreLootTable).put((Object)AEBlocks.DEEPSLATE_QUARTZ_ORE.block(), BlockDropProvider::createQuartzOreLootTable).build();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final Path outputFolder;

    public BlockDropProvider(Path outputFolder) {
        this.outputFolder = outputFolder;
    }

    public void m_6865_(HashCache cache) throws IOException {
        for (Map.Entry entry : Registry.f_122824_.m_6579_()) {
            if (!((ResourceKey)entry.getKey()).m_135782_().m_135827_().equals("ae2")) continue;
            LootTable.Builder builder = this.overrides.getOrDefault(entry.getValue(), this::defaultBuilder).apply((Block)entry.getValue());
            DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)this.toJson(builder), (Path)this.getPath(this.outputFolder, ((ResourceKey)entry.getKey()).m_135782_()));
        }
        DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)this.toJson(LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_(AEBlocks.SKY_STONE_BLOCK)))), (Path)this.getPath(this.outputFolder, AppEng.makeId("chests/meteorite")));
    }

    private LootTable.Builder defaultBuilder(Block block) {
        LootPoolSingletonContainer.Builder entry = LootItem.m_79579_((ItemLike)block);
        LootPool.Builder pool = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)entry).m_6509_(ExplosionCondition.m_81661_());
        return LootTable.m_79147_().m_79161_(pool);
    }

    private static LootTable.Builder createQuartzOreLootTable(Block b) {
        return BlockDropProvider.m_124168_((Block)b, (LootPoolEntryContainer.Builder)LootItem.m_79579_(AEItems.CERTUS_QUARTZ_DUST).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)5.0f))).m_5577_((LootItemFunction.Builder)ApplyBonusCount.m_79939_((Enchantment)Enchantments.f_44987_)).m_5577_((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_())).m_79161_(LootPool.m_79043_().m_6509_(f_124063_).m_6509_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])new float[]{0.05f, 0.1f, 0.15f, 0.2f})).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_(AEItems.CERTUS_QUARTZ_CRYSTAL).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f))).m_5577_((LootItemFunction.Builder)ApplyBonusCount.m_79939_((Enchantment)Enchantments.f_44987_)).m_5577_((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_())));
    }

    private Path getPath(Path root, ResourceLocation id) {
        return root.resolve("data/" + id.m_135827_() + "/loot_tables/blocks/" + id.m_135815_() + ".json");
    }

    public JsonElement toJson(LootTable.Builder builder) {
        return LootTables.m_79200_((LootTable)this.finishBuilding(builder));
    }

    public LootTable finishBuilding(LootTable.Builder builder) {
        return builder.m_79165_(LootContextParamSets.f_81421_).m_79167_();
    }

    public String m_6055_() {
        return "Applied Energistics 2 Block Drops";
    }
}

