/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.core.sync.BasePacket;
import appeng.menu.AEBaseMenu;
import io.netty.buffer.Unpooled;
import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class GuiDataSyncPacket
extends BasePacket {
    private final int containerId;
    private final FriendlyByteBuf data;

    public GuiDataSyncPacket(int containerId, Consumer<FriendlyByteBuf> writer) {
        this.containerId = 0;
        this.data = null;
        FriendlyByteBuf data = new FriendlyByteBuf(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        data.m_130130_(containerId);
        writer.accept(data);
        this.configureWrite(data);
    }

    public GuiDataSyncPacket(FriendlyByteBuf data) {
        this.containerId = data.m_130242_();
        this.data = new FriendlyByteBuf(data.copy());
    }

    public FriendlyByteBuf getData() {
        return this.data;
    }

    @Override
    public void clientPacketData(Player player) {
        AbstractContainerMenu c = player.f_36096_;
        if (c instanceof AEBaseMenu && c.f_38840_ == this.containerId) {
            ((AEBaseMenu)c).receiveServerSyncData(this);
        }
    }

    @Override
    public void serverPacketData(ServerPlayer player) {
        AbstractContainerMenu c = player.f_36096_;
        if (c instanceof AEBaseMenu && c.f_38840_ == this.containerId) {
            ((AEBaseMenu)c).receiveClientAction(this);
        }
    }
}

