/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.tesr;

import appeng.api.inventories.InternalInventory;
import appeng.blockentity.misc.InscriberBlockEntity;
import appeng.client.render.FacingToRotation;
import appeng.datagen.providers.tags.ConventionTags;
import appeng.recipes.handlers.InscriberProcessType;
import appeng.recipes.handlers.InscriberRecipe;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.TextureStitchEvent;

public final class InscriberTESR
implements BlockEntityRenderer<InscriberBlockEntity> {
    private static final float ITEM_RENDER_SCALE = 0.8333333f;
    private static final Material TEXTURE_INSIDE = new Material(InventoryMenu.f_39692_, new ResourceLocation("ae2", "block/inscriber_inside"));

    public InscriberTESR(BlockEntityRendererProvider.Context context) {
    }

    public void render(InscriberBlockEntity blockEntity, float partialTicks, PoseStack ms, MultiBufferSource buffers, int combinedLight, int combinedOverlay) {
        boolean renderPresses;
        float relativeProgress;
        float progress;
        long currentTime;
        ms.m_85836_();
        ms.m_85837_(0.5, 0.5, 0.5);
        FacingToRotation.get(blockEntity.getForward(), blockEntity.getUp()).push(ms);
        ms.m_85837_(-0.5, -0.5, -0.5);
        long absoluteProgress = 0L;
        if (blockEntity.isSmash() && (absoluteProgress = (currentTime = System.currentTimeMillis()) - blockEntity.getClientStart()) > 800L) {
            blockEntity.setSmash(false);
        }
        progress = (progress = (relativeProgress = (float)(absoluteProgress % 800L) / 400.0f)) > 1.0f ? 1.0f - InscriberTESR.easeDecompressMotion(progress - 1.0f) : InscriberTESR.easeCompressMotion(progress);
        float press = 0.2f;
        press -= progress / 5.0f;
        float middle = 0.5f;
        float TwoPx = 0.125f;
        float base = 0.4f;
        TextureAtlasSprite tas = TEXTURE_INSIDE.m_119204_();
        VertexConsumer buffer = buffers.m_6299_(RenderType.m_110451_());
        InscriberTESR.addVertex(buffer, ms, tas, 0.125f, (middle += 0.02f) + press, 0.125f, 2.0, 13.0, combinedOverlay, combinedLight, Direction.DOWN);
        InscriberTESR.addVertex(buffer, ms, tas, 0.875f, middle + press, 0.125f, 14.0, 13.0, combinedOverlay, combinedLight, Direction.DOWN);
        InscriberTESR.addVertex(buffer, ms, tas, 0.875f, middle + press, 0.875f, 14.0, 2.0, combinedOverlay, combinedLight, Direction.DOWN);
        InscriberTESR.addVertex(buffer, ms, tas, 0.125f, middle + press, 0.875f, 2.0, 2.0, combinedOverlay, combinedLight, Direction.DOWN);
        InscriberTESR.addVertex(buffer, ms, tas, 0.125f, middle + 0.4f, 0.125f, 2.0, 3.0f - 16.0f * (press - 0.4f), combinedOverlay, combinedLight, Direction.NORTH);
        InscriberTESR.addVertex(buffer, ms, tas, 0.875f, middle + 0.4f, 0.125f, 14.0, 3.0f - 16.0f * (press - 0.4f), combinedOverlay, combinedLight, Direction.NORTH);
        InscriberTESR.addVertex(buffer, ms, tas, 0.875f, middle + press, 0.125f, 14.0, 3.0, combinedOverlay, combinedLight, Direction.NORTH);
        InscriberTESR.addVertex(buffer, ms, tas, 0.125f, middle + press, 0.125f, 2.0, 3.0, combinedOverlay, combinedLight, Direction.NORTH);
        InscriberTESR.addVertex(buffer, ms, tas, 0.875f, (middle -= 0.04f) - press, 0.125f, 2.0, 13.0, combinedOverlay, combinedLight, Direction.UP);
        InscriberTESR.addVertex(buffer, ms, tas, 0.125f, middle - press, 0.125f, 14.0, 13.0, combinedOverlay, combinedLight, Direction.UP);
        InscriberTESR.addVertex(buffer, ms, tas, 0.125f, middle - press, 0.875f, 14.0, 2.0, combinedOverlay, combinedLight, Direction.UP);
        InscriberTESR.addVertex(buffer, ms, tas, 0.875f, middle - press, 0.875f, 2.0, 2.0, combinedOverlay, combinedLight, Direction.UP);
        InscriberTESR.addVertex(buffer, ms, tas, 0.875f, middle + -0.4f, 0.125f, 2.0, 3.0f - 16.0f * (press - 0.4f), combinedOverlay, combinedLight, Direction.NORTH);
        InscriberTESR.addVertex(buffer, ms, tas, 0.125f, middle - 0.4f, 0.125f, 14.0, 3.0f - 16.0f * (press - 0.4f), combinedOverlay, combinedLight, Direction.NORTH);
        InscriberTESR.addVertex(buffer, ms, tas, 0.125f, middle - press, 0.125f, 14.0, 3.0, combinedOverlay, combinedLight, Direction.NORTH);
        InscriberTESR.addVertex(buffer, ms, tas, 0.875f, middle - press, 0.125f, 2.0, 3.0, combinedOverlay, combinedLight, Direction.NORTH);
        InternalInventory inv = blockEntity.getInternalInventory();
        int items = 0;
        if (!inv.getStackInSlot(0).m_41619_()) {
            ++items;
        }
        if (!inv.getStackInSlot(1).m_41619_()) {
            ++items;
        }
        if (!inv.getStackInSlot(2).m_41619_()) {
            ++items;
        }
        if (relativeProgress > 1.0f || items == 0) {
            InscriberRecipe ir;
            renderPresses = false;
            ItemStack is = inv.getStackInSlot(3);
            if (is.m_41619_() && (ir = blockEntity.getTask()) != null) {
                renderPresses = ir.getProcessType() == InscriberProcessType.INSCRIBE;
                is = ir.m_8043_().m_41777_();
            }
            this.renderItem(ms, is, 0.0f, buffers, combinedLight, combinedOverlay);
        } else {
            renderPresses = true;
            this.renderItem(ms, inv.getStackInSlot(2), 0.0f, buffers, combinedLight, combinedOverlay);
        }
        if (renderPresses) {
            this.renderItem(ms, inv.getStackInSlot(0), press, buffers, combinedLight, combinedOverlay);
            this.renderItem(ms, inv.getStackInSlot(1), -press, buffers, combinedLight, combinedOverlay);
        }
        ms.m_85849_();
    }

    private static void addVertex(VertexConsumer vb, PoseStack ms, TextureAtlasSprite sprite, float x, float y, float z, double texU, double texV, int overlayUV, int lightmapUV, Direction front) {
        vb.m_85982_(ms.m_85850_().m_85861_(), x, y, z);
        vb.m_85950_(1.0f, 1.0f, 1.0f, 1.0f);
        vb.m_7421_(sprite.m_118367_(texU), sprite.m_118393_(texV));
        vb.m_86008_(overlayUV);
        vb.m_85969_(lightmapUV);
        vb.m_85977_(ms.m_85850_().m_85864_(), (float)front.m_122429_(), (float)front.m_122430_(), (float)front.m_122431_());
        vb.m_5752_();
    }

    private void renderItem(PoseStack ms, ItemStack stack, float o, MultiBufferSource buffers, int combinedLight, int combinedOverlay) {
        if (!stack.m_41619_()) {
            ms.m_85836_();
            ms.m_85837_(0.5, (double)(0.5f + o), 0.5);
            ms.m_85845_(new Quaternion(90.0f, 0.0f, 0.0f, true));
            ms.m_85841_(0.8333333f, 0.8333333f, 0.8333333f);
            ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
            if (!stack.m_204117_(ConventionTags.STORAGE_BLOCKS)) {
                ms.m_85841_(0.5f, 0.5f, 0.5f);
            }
            RenderSystem.m_157182_();
            itemRenderer.m_174269_(stack, ItemTransforms.TransformType.FIXED, combinedLight, combinedOverlay, ms, buffers, 0);
            ms.m_85849_();
        }
    }

    public static void registerTexture(TextureStitchEvent.Pre evt) {
        if (evt.getAtlas().m_118330_().equals((Object)TEXTURE_INSIDE.m_119193_())) {
            evt.addSprite(TEXTURE_INSIDE.m_119203_());
        }
    }

    private static float easeCompressMotion(float x) {
        float c1 = 1.70158f;
        float c3 = c1 + 1.0f;
        return (float)(1.0 + (double)c3 * Math.pow(x - 1.0f, 3.0) + (double)c1 * Math.pow(x - 1.0f, 2.0));
    }

    private static float easeDecompressMotion(float x) {
        return x * x * x * x * x;
    }
}

