/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.model;

import appeng.api.implementations.items.IMemoryCard;
import appeng.api.util.AEColor;
import appeng.client.render.cablebus.CubeBuilder;
import appeng.core.AELog;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

class MemoryCardBakedModel
implements BakedModel {
    private static final AEColor[] DEFAULT_COLOR_CODE = new AEColor[]{AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT};
    private final BakedModel baseModel;
    private final TextureAtlasSprite texture;
    private final AEColor[] colorCode;
    private final Cache<CacheKey, MemoryCardBakedModel> modelCache;
    private final ImmutableList<BakedQuad> generalQuads;

    MemoryCardBakedModel(BakedModel baseModel, TextureAtlasSprite texture) {
        this(baseModel, texture, DEFAULT_COLOR_CODE, MemoryCardBakedModel.createCache());
    }

    private MemoryCardBakedModel(BakedModel baseModel, TextureAtlasSprite texture, AEColor[] hash, Cache<CacheKey, MemoryCardBakedModel> modelCache) {
        this.baseModel = baseModel;
        this.texture = texture;
        this.colorCode = hash;
        this.generalQuads = ImmutableList.copyOf(this.buildGeneralQuads());
        this.modelCache = modelCache;
    }

    private static Cache<CacheKey, MemoryCardBakedModel> createCache() {
        return CacheBuilder.newBuilder().maximumSize(100L).build();
    }

    public List<BakedQuad> m_6840_(@Nullable BlockState state, @Nullable Direction side, Random rand) {
        List quads = this.baseModel.getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE);
        if (side != null) {
            return quads;
        }
        ArrayList<BakedQuad> result = new ArrayList<BakedQuad>(quads.size() + this.generalQuads.size());
        result.addAll(quads);
        result.addAll((Collection<BakedQuad>)this.generalQuads);
        return result;
    }

    private List<BakedQuad> buildGeneralQuads() {
        CubeBuilder builder = new CubeBuilder();
        builder.setTexture(this.texture);
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 2; ++y) {
                AEColor color = this.colorCode[x + y * 4];
                builder.setColorRGB(color.mediumVariant);
                builder.addCube(7 + x, 9 - y, 7.5f, 7 + x + 1, 9 - y + 1, 8.5f);
            }
        }
        return builder.getOutput();
    }

    public boolean m_7541_() {
        return this.baseModel.m_7541_();
    }

    public boolean m_7539_() {
        return this.baseModel.m_7539_();
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return this.baseModel.m_7521_();
    }

    public TextureAtlasSprite m_6160_() {
        return this.baseModel.m_6160_();
    }

    public ItemTransforms m_7442_() {
        return this.baseModel.m_7442_();
    }

    public ItemOverrides m_7343_() {
        return new ItemOverrides(){

            public BakedModel m_173464_(BakedModel originalModel, ItemStack stack, ClientLevel level, LivingEntity entity, int seed) {
                try {
                    Item item = stack.m_41720_();
                    if (item instanceof IMemoryCard) {
                        IMemoryCard memoryCard = (IMemoryCard)item;
                        AEColor[] colors = memoryCard.getColorCode(stack);
                        return (BakedModel)MemoryCardBakedModel.this.modelCache.get((Object)new CacheKey(colors), () -> new MemoryCardBakedModel(MemoryCardBakedModel.this.baseModel, MemoryCardBakedModel.this.texture, colors, MemoryCardBakedModel.this.modelCache));
                    }
                }
                catch (ExecutionException e) {
                    AELog.error(e);
                }
                return MemoryCardBakedModel.this;
            }
        };
    }

    public BakedModel handlePerspective(ItemTransforms.TransformType cameraTransformType, PoseStack mat) {
        this.baseModel.handlePerspective(cameraTransformType, mat);
        return this;
    }

    private static class CacheKey {
        private final AEColor[] key;

        CacheKey(AEColor[] key) {
            this.key = key;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode((Object[])this.key);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            return Arrays.equals((Object[])this.key, (Object[])other.key);
        }
    }
}

