/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity.storage;

import appeng.api.implementations.blockentities.IChestOrDrive;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNodeListener;
import appeng.api.storage.IStorageMounts;
import appeng.api.storage.IStorageProvider;
import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.StorageCell;
import appeng.api.util.AECableType;
import appeng.blockentity.grid.AENetworkInvBlockEntity;
import appeng.blockentity.inventory.AppEngCellInventory;
import appeng.client.render.model.DriveModelData;
import appeng.core.definitions.AEBlocks;
import appeng.helpers.IPriorityHost;
import appeng.me.storage.DriveWatcher;
import appeng.menu.ISubMenu;
import appeng.menu.MenuOpener;
import appeng.menu.implementations.DriveMenu;
import appeng.menu.locator.MenuLocators;
import appeng.util.inv.filter.IAEItemFilter;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.IModelData;

public class DriveBlockEntity
extends AENetworkInvBlockEntity
implements IChestOrDrive,
IPriorityHost,
IStorageProvider {
    private static final int SLOT_COUNT = 10;
    private static final int BIT_POWER_MASK = Integer.MIN_VALUE;
    private static final int BIT_STATE_MASK = 0x3FFFFFFF;
    private static final int BIT_CELL_STATE_MASK = 7;
    private static final int BIT_CELL_STATE_BITS = 3;
    private final AppEngCellInventory inv = new AppEngCellInventory(this, 10);
    private final DriveWatcher[] invBySlot = new DriveWatcher[10];
    private boolean isCached = false;
    private int priority = 0;
    private boolean wasOnline = false;
    private final Item[] cellItems = new Item[10];
    private int state = 0;

    public DriveBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState blockState) {
        super(blockEntityType, pos, blockState);
        this.getMainNode().addService(IStorageProvider.class, this).setFlags(GridFlags.REQUIRE_CHANNEL);
        this.inv.setFilter(new CellValidInventoryFilter());
    }

    @Override
    public void setOrientation(Direction inForward, Direction inUp) {
        super.setOrientation(inForward, inUp);
        this.getMainNode().setExposedOnSides(EnumSet.complementOf(EnumSet.of(inForward)));
    }

    @Override
    protected void writeToStream(FriendlyByteBuf data) {
        super.writeToStream(data);
        this.state = this.calculateCurrentVisualState();
        data.writeInt(this.state);
        this.writeCellItemIds(data);
    }

    private void writeCellItemIds(FriendlyByteBuf data) {
        ArrayList<ResourceLocation> cellItemIds = new ArrayList<ResourceLocation>(this.getCellCount());
        byte[] bm = new byte[this.getCellCount()];
        for (int x = 0; x < this.getCellCount(); ++x) {
            Item item = this.getCellItem(x);
            if (item == null || Objects.equals(Registry.f_122827_.m_7981_((Object)item), Registry.f_122827_.m_122315_())) continue;
            ResourceLocation itemId = Registry.f_122827_.m_7981_((Object)item);
            int idx = cellItemIds.indexOf(itemId);
            if (idx == -1) {
                cellItemIds.add(itemId);
                bm[x] = (byte)cellItemIds.size();
                continue;
            }
            bm[x] = (byte)(1 + idx);
        }
        data.writeByte(cellItemIds.size());
        for (ResourceLocation itemId : cellItemIds) {
            data.m_130085_(itemId);
        }
        for (int i = 0; i < this.getCellCount(); ++i) {
            data.writeByte((int)bm[i]);
        }
    }

    @Override
    protected boolean readFromStream(FriendlyByteBuf data) {
        boolean c = super.readFromStream(data);
        int oldState = this.state;
        this.state = data.readInt();
        return (this.state & 0x3FFFFFFF) != (oldState & 0x3FFFFFFF) || (c |= this.readCellItemIDs(data));
    }

    private boolean readCellItemIDs(FriendlyByteBuf data) {
        int uniqueStrCount = data.readByte();
        String[] uniqueStrs = new String[uniqueStrCount];
        for (int i = 0; i < uniqueStrCount; ++i) {
            uniqueStrs[i] = data.m_130277_();
        }
        boolean changed = false;
        for (int i = 0; i < this.getCellCount(); ++i) {
            byte idx = data.readByte();
            Item item = null;
            if (idx > 0) {
                idx = (byte)(idx - 1);
                String itemId = uniqueStrs[idx];
                item = (Item)Registry.f_122827_.m_7745_(new ResourceLocation(itemId));
            }
            if (this.cellItems[i] == item) continue;
            changed = true;
            this.cellItems[i] = item;
        }
        return changed;
    }

    @Override
    public int getCellCount() {
        return 10;
    }

    @Override
    @Nullable
    public Item getCellItem(int slot) {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return this.cellItems[slot];
        }
        ItemStack stackInSlot = this.inv.getStackInSlot(slot);
        if (!stackInSlot.m_41619_()) {
            return stackInSlot.m_41720_();
        }
        return null;
    }

    @Override
    public CellState getCellStatus(int slot) {
        if (this.isClientSide()) {
            int cellState = this.state >> slot * 3 & 7;
            return CellState.values()[cellState];
        }
        DriveWatcher handler = this.invBySlot[slot];
        if (handler == null) {
            return CellState.ABSENT;
        }
        return handler.getStatus();
    }

    @Override
    public boolean isPowered() {
        if (this.isClientSide()) {
            return (this.state & Integer.MIN_VALUE) == Integer.MIN_VALUE;
        }
        return this.getMainNode().isOnline();
    }

    @Override
    public boolean isCellBlinking(int slot) {
        return false;
    }

    @Override
    public void loadTag(CompoundTag data) {
        super.loadTag(data);
        this.isCached = false;
        this.priority = data.m_128451_("priority");
    }

    @Override
    public void m_183515_(CompoundTag data) {
        super.m_183515_(data);
        data.m_128405_("priority", this.priority);
    }

    private void updateVisualStateIfNeeded() {
        int newState = this.calculateCurrentVisualState();
        if (newState != this.state) {
            this.state = newState;
            this.markForUpdate();
        }
    }

    private int calculateCurrentVisualState() {
        this.updateState();
        int newState = 0;
        if (this.getMainNode().isOnline()) {
            newState |= Integer.MIN_VALUE;
        }
        for (int x = 0; x < this.getCellCount(); ++x) {
            newState |= this.getCellStatus(x).ordinal() << 3 * x;
        }
        return newState;
    }

    @Override
    public void onMainNodeStateChanged(IGridNodeListener.State reason) {
        boolean currentOnline = this.getMainNode().isOnline();
        if (this.wasOnline != currentOnline) {
            this.wasOnline = currentOnline;
            IStorageProvider.requestUpdate(this.getMainNode());
            this.updateVisualStateIfNeeded();
        }
    }

    @Override
    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.SMART;
    }

    @Override
    public InternalInventory getInternalInventory() {
        return this.inv;
    }

    @Override
    public void onChangeInventory(InternalInventory inv, int slot) {
        if (this.isCached) {
            this.isCached = false;
            this.updateState();
        }
        IStorageProvider.requestUpdate(this.getMainNode());
        this.markForUpdate();
    }

    private void updateState() {
        if (!this.isCached) {
            double power = 2.0;
            for (int slot = 0; slot < this.inv.size(); ++slot) {
                power += this.updateStateForSlot(slot);
            }
            this.getMainNode().setIdlePowerUsage(power);
            this.isCached = true;
        }
    }

    private double updateStateForSlot(int slot) {
        StorageCell cell;
        this.invBySlot[slot] = null;
        this.inv.setHandler(slot, null);
        ItemStack is = this.inv.getStackInSlot(slot);
        if (!is.m_41619_() && (cell = StorageCells.getCellInventory(is, this::onCellContentChanged)) != null) {
            DriveWatcher driveWatcher;
            this.inv.setHandler(slot, cell);
            this.invBySlot[slot] = driveWatcher = new DriveWatcher(cell, () -> this.blinkCell(slot));
            return cell.getIdleDrain();
        }
        return 0.0;
    }

    @Override
    public void onReady() {
        super.onReady();
        this.updateState();
    }

    @Override
    public void mountInventories(IStorageMounts storageMounts) {
        if (this.getMainNode().isOnline()) {
            this.updateState();
            for (DriveWatcher inventory : this.invBySlot) {
                if (inventory == null) continue;
                storageMounts.mount(inventory, this.priority);
            }
        }
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int newValue) {
        this.priority = newValue;
        this.saveChanges();
        this.isCached = false;
        this.updateState();
        IStorageProvider.requestUpdate(this.getMainNode());
    }

    private void blinkCell(int slot) {
        this.updateVisualStateIfNeeded();
    }

    private void onCellContentChanged() {
        this.f_58857_.m_151543_(this.f_58858_);
    }

    @Override
    public IModelData getModelData() {
        Item[] cells = new Item[this.getCellCount()];
        for (int i = 0; i < this.getCellCount(); ++i) {
            cells[i] = this.getCellItem(i);
        }
        return new DriveModelData(this.getUp(), this.getForward(), cells);
    }

    public void openMenu(Player player) {
        MenuOpener.open(DriveMenu.TYPE, player, MenuLocators.forBlockEntity(this));
    }

    @Override
    public void returnToMainMenu(Player player, ISubMenu subMenu) {
        this.openMenu(player);
    }

    @Override
    public ItemStack getMainMenuIcon() {
        return AEBlocks.DRIVE.stack();
    }

    private static class CellValidInventoryFilter
    implements IAEItemFilter {
        private CellValidInventoryFilter() {
        }

        @Override
        public boolean allowExtract(InternalInventory inv, int slot, int amount) {
            return true;
        }

        @Override
        public boolean allowInsert(InternalInventory inv, int slot, ItemStack stack) {
            return !stack.m_41619_() && StorageCells.isCellHandled(stack);
        }
    }
}

