/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity.misc;

import appeng.api.config.Actionable;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.util.AECableType;
import appeng.blockentity.grid.AENetworkInvBlockEntity;
import appeng.core.settings.TickRates;
import appeng.util.Platform;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.FilteredInternalInventory;
import appeng.util.inv.filter.IAEItemFilter;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeHooks;

public class VibrationChamberBlockEntity
extends AENetworkInvBlockEntity
implements IGridTickable {
    public static final double POWER_PER_TICK = 5.0;
    public static final int MIN_BURN_SPEED = 20;
    public static final int MAX_BURN_SPEED = 200;
    public static final double DILATION_SCALING = 25.0;
    private final AppEngInternalInventory inv = new AppEngInternalInventory(this, 1);
    private final InternalInventory invExt = new FilteredInternalInventory(this.inv, new FuelSlotFilter());
    private int burnSpeed = 100;
    private double burnTime = 0.0;
    private double maxBurnTime = 0.0;
    public boolean isOn;

    public VibrationChamberBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState blockState) {
        super(blockEntityType, pos, blockState);
        this.getMainNode().setIdlePowerUsage(0.0).setFlags(new GridFlags[0]).addService(IGridTickable.class, this);
    }

    @Override
    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.COVERED;
    }

    @Override
    protected boolean readFromStream(FriendlyByteBuf data) {
        boolean c = super.readFromStream(data);
        boolean wasOn = this.isOn;
        this.isOn = data.readBoolean();
        return wasOn != this.isOn || c;
    }

    @Override
    protected void writeToStream(FriendlyByteBuf data) {
        super.writeToStream(data);
        data.writeBoolean(this.getBurnTime() > 0.0);
    }

    @Override
    public void m_183515_(CompoundTag data) {
        super.m_183515_(data);
        data.m_128347_("burnTime", this.getBurnTime());
        data.m_128347_("maxBurnTime", this.getMaxBurnTime());
        data.m_128405_("burnSpeed", this.getBurnSpeed());
    }

    @Override
    public void loadTag(CompoundTag data) {
        super.loadTag(data);
        this.setBurnTime(data.m_128459_("burnTime"));
        this.setMaxBurnTime(data.m_128459_("maxBurnTime"));
        this.setBurnSpeed(data.m_128451_("burnSpeed"));
    }

    @Override
    protected InternalInventory getExposedInventoryForSide(Direction facing) {
        return this.invExt;
    }

    @Override
    public InternalInventory getInternalInventory() {
        return this.inv;
    }

    @Override
    public void onChangeInventory(InternalInventory inv, int slot) {
        if (this.getBurnTime() <= 0.0 && this.canEatFuel()) {
            this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().wakeDevice((IGridNode)node));
        }
    }

    private boolean canEatFuel() {
        int newBurnTime;
        ItemStack is = this.inv.getStackInSlot(0);
        return !is.m_41619_() && (newBurnTime = VibrationChamberBlockEntity.getBurnTime(is)) > 0 && is.m_41613_() > 0;
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        if (this.getBurnTime() <= 0.0) {
            this.eatFuel();
        }
        return new TickingRequest(TickRates.VibrationChamber, this.getBurnTime() <= 0.0, false);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (this.getBurnTime() <= 0.0) {
            this.eatFuel();
            if (this.getBurnTime() > 0.0) {
                return TickRateModulation.URGENT;
            }
            this.setBurnSpeed(100);
            return TickRateModulation.SLEEP;
        }
        this.setBurnSpeed(Math.max(20, Math.min(this.getBurnSpeed(), 200)));
        double dilation = (double)this.getBurnSpeed() / 25.0;
        double timePassed = (double)ticksSinceLastCall * dilation;
        this.setBurnTime(this.getBurnTime() - timePassed);
        if (this.getBurnTime() < 0.0) {
            timePassed += this.getBurnTime();
            this.setBurnTime(0.0);
        }
        IGrid grid = node.getGrid();
        IEnergyService energy = grid.getEnergyService();
        double newPower = timePassed * 5.0;
        double overFlow = energy.injectPower(newPower, Actionable.SIMULATE);
        energy.injectPower(Math.max(0.0, newPower - overFlow), Actionable.MODULATE);
        if (overFlow > 0.0) {
            this.setBurnSpeed(this.getBurnSpeed() - ticksSinceLastCall);
        } else {
            this.setBurnSpeed(this.getBurnSpeed() + ticksSinceLastCall);
        }
        this.setBurnSpeed(Math.max(20, Math.min(this.getBurnSpeed(), 200)));
        return overFlow > 0.0 ? TickRateModulation.SLOWER : TickRateModulation.FASTER;
    }

    private void eatFuel() {
        int newBurnTime;
        ItemStack is = this.inv.getStackInSlot(0);
        if (!is.m_41619_() && (newBurnTime = VibrationChamberBlockEntity.getBurnTime(is)) > 0 && is.m_41613_() > 0) {
            this.setBurnTime(this.getBurnTime() + (double)newBurnTime);
            this.setMaxBurnTime(this.getBurnTime());
            Item fuelItem = is.m_41720_();
            is.m_41774_(1);
            if (is.m_41619_()) {
                this.inv.setItemDirect(0, fuelItem.getContainerItem(is));
            } else {
                this.inv.setItemDirect(0, is);
            }
            this.saveChanges();
        }
        if (this.getBurnTime() > 0.0) {
            this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().wakeDevice((IGridNode)node));
        }
        if (!this.isOn && this.getBurnTime() > 0.0 || this.isOn && this.getBurnTime() <= 0.0) {
            this.isOn = this.getBurnTime() > 0.0;
            this.markForUpdate();
            if (this.m_58898_()) {
                Platform.notifyBlocksOfNeighbors(this.f_58857_, this.f_58858_);
            }
        }
    }

    public static int getBurnTime(ItemStack is) {
        return ForgeHooks.getBurnTime((ItemStack)is, null);
    }

    public static boolean hasBurnTime(ItemStack is) {
        return VibrationChamberBlockEntity.getBurnTime(is) > 0;
    }

    public int getBurnSpeed() {
        return this.burnSpeed;
    }

    private void setBurnSpeed(int burnSpeed) {
        this.burnSpeed = burnSpeed;
    }

    public double getMaxBurnTime() {
        return this.maxBurnTime;
    }

    private void setMaxBurnTime(double maxBurnTime) {
        this.maxBurnTime = maxBurnTime;
    }

    public double getBurnTime() {
        return this.burnTime;
    }

    private void setBurnTime(double burnTime) {
        this.burnTime = burnTime;
    }

    private static class FuelSlotFilter
    implements IAEItemFilter {
        private FuelSlotFilter() {
        }

        @Override
        public boolean allowExtract(InternalInventory inv, int slot, int amount) {
            return !VibrationChamberBlockEntity.hasBurnTime(inv.getStackInSlot(slot));
        }

        @Override
        public boolean allowInsert(InternalInventory inv, int slot, ItemStack stack) {
            return VibrationChamberBlockEntity.hasBurnTime(stack);
        }
    }
}

