/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.features;

import appeng.api.features.P2PTunnelAttunement;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.Capability;

public final class P2PTunnelAttunementInternal {
    private P2PTunnelAttunementInternal() {
    }

    public static AttunementInfo getAttunementInfo(ItemLike tunnelType) {
        Item tunnelItem = tunnelType.m_5456_();
        HashSet<Item> items = new HashSet<Item>();
        HashSet<String> mods = new HashSet<String>();
        HashSet caps = new HashSet();
        for (Map.Entry<Item, Item> entry : P2PTunnelAttunement.tunnels.entrySet()) {
            if (entry.getValue() != tunnelItem) continue;
            items.add(entry.getKey());
        }
        for (Map.Entry<Object, Item> entry : P2PTunnelAttunement.modIdTunnels.entrySet()) {
            if (entry.getValue() != tunnelItem) continue;
            mods.add((String)entry.getKey());
        }
        for (P2PTunnelAttunement.ApiAttunement apiAttunement : P2PTunnelAttunement.apiAttunements) {
            if (apiAttunement.tunnelType() != tunnelItem) continue;
            caps.add(apiAttunement.capability());
        }
        return new AttunementInfo(items, mods, caps);
    }

    public static List<Resultant> getApiTunnels() {
        return P2PTunnelAttunement.apiAttunements.stream().map(info -> new Resultant(info.component(), info.tunnelType(), info::hasApi)).toList();
    }

    public static Map<TagKey<Item>, Item> getTagTunnels() {
        return P2PTunnelAttunement.tagTunnels;
    }

    public record AttunementInfo(Set<Item> items, Set<String> mods, Set<Capability<?>> apis) {
    }

    public record Resultant(Component description, Item tunnelType, Predicate<ItemStack> stackPredicate) {
    }
}

