/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.innovation.config;

import cofh.lib.config.IBaseConfig;
import cofh.thermal.innovation.init.TInoReferences;
import net.minecraftforge.common.ForgeConfigSpec;

public class TInoToolConfig
implements IBaseConfig {
    private ForgeConfigSpec.IntValue rfDrillMaxEnergy;
    private ForgeConfigSpec.IntValue rfSawMaxEnergy;
    private ForgeConfigSpec.IntValue rfCapacitorMaxEnergy;
    private ForgeConfigSpec.IntValue rfMagnetMaxEnergy;
    private ForgeConfigSpec.IntValue fluidReservoirCapacity;
    private ForgeConfigSpec.IntValue potionInfuserCapacity;
    private ForgeConfigSpec.IntValue potionQuiverCapacity;

    public void apply(ForgeConfigSpec.Builder builder) {
        builder.push("Tools");
        builder.push("Drill");
        this.rfDrillMaxEnergy = builder.comment("This sets the maximum base RF capacity for the Fluxbore.").defineInRange("Base Capacity", 50000, 1000, 10000000);
        builder.pop();
        builder.push("Saw");
        this.rfSawMaxEnergy = builder.comment("This sets the maximum base RF capacity for the Fluxsaw.").defineInRange("Base Capacity", 50000, 1000, 10000000);
        builder.pop();
        builder.push("Capacitor");
        this.rfCapacitorMaxEnergy = builder.comment("This sets the maximum base RF capacity for the Flux Capacitor.").defineInRange("Base Capacity", 500000, 1000, 10000000);
        builder.pop();
        builder.push("Magnet");
        this.rfMagnetMaxEnergy = builder.comment("This sets the maximum base RF capacity for the Flux Magnet.").defineInRange("Base Capacity", 50000, 1000, 10000000);
        builder.pop();
        builder.push("Reservoir");
        this.fluidReservoirCapacity = builder.comment("This sets the maximum base fluid capacity for the Reservoir.").defineInRange("Base Capacity", 20000, 1000, 10000000);
        builder.pop();
        builder.push("Potion Infuser");
        this.potionInfuserCapacity = builder.comment("This sets the maximum base fluid capacity for the Potion Infuser.").defineInRange("Base Capacity", 4000, 1000, 10000000);
        builder.pop();
        builder.push("Potion Quiver");
        this.potionQuiverCapacity = builder.comment("This sets the maximum base fluid capacity for the Alchemical Quiver.").defineInRange("Base Capacity", 4000, 1000, 10000000);
        builder.pop();
        builder.pop();
    }

    public void refresh() {
        if (TInoReferences.FLUX_DRILL_ITEM == null) {
            return;
        }
        TInoReferences.FLUX_DRILL_ITEM.setMaxEnergy((Integer)this.rfDrillMaxEnergy.get());
        TInoReferences.FLUX_SAW_ITEM.setMaxEnergy((Integer)this.rfSawMaxEnergy.get());
        TInoReferences.FLUX_CAPACITOR_ITEM.setMaxEnergy((Integer)this.rfCapacitorMaxEnergy.get());
        TInoReferences.FLUX_MAGNET_ITEM.setMaxEnergy((Integer)this.rfMagnetMaxEnergy.get());
        TInoReferences.FLUID_RESERVOIR_ITEM.setFluidCapacity((Integer)this.fluidReservoirCapacity.get());
        TInoReferences.POTION_INFUSER_ITEM.setFluidCapacity((Integer)this.potionInfuserCapacity.get());
        TInoReferences.POTION_QUIVER_ITEM.setFluidCapacity((Integer)this.potionQuiverCapacity.get());
    }
}

