/*
 * Decompiled with CFR 0.152.
 */
package io.siuolplex.soul_ice.forge.mixin;

import io.siuolplex.soul_ice.SoulIce;
import io.siuolplex.soul_ice.SoulIceConfig;
import io.siuolplex.soul_ice.forge.util.SoulIceEnchantSyncer;
import io.siuolplex.soul_ice.forge.util.SoulIceSlipSetter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.game.ClientboundCustomPayloadPacket;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientPacketListener.class})
public class ClientPlayNetworkHandlerMixin {
    @Shadow
    @Final
    private Minecraft f_104888_;

    @Inject(method={"onCustomPayload"}, at={@At(value="HEAD")}, cancellable=true)
    private void soulIce$catchPackets(ClientboundCustomPayloadPacket packet, CallbackInfo ci) {
        try {
            if (packet.getName().equals((Object)SoulIce.soulIceSyncID)) {
                float serverSlip = packet.m_132045_().readFloat();
                this.f_104888_.execute(() -> SoulIceSlipSetter.soulIceSlip(serverSlip));
            } else if (packet.getName().equals((Object)SoulIce.unfalteringSyncID)) {
                boolean isUnfalteringEnabled = packet.m_132045_().readBoolean();
                this.f_104888_.execute(() -> SoulIceEnchantSyncer.setIsUnfalteringEnabled(isUnfalteringEnabled));
            } else if (packet.getName().equals((Object)SoulIce.freezingSyncID)) {
                boolean isFreezingEnabled = packet.m_132045_().readBoolean();
                this.f_104888_.execute(() -> SoulIceEnchantSyncer.setIsFreezingEnabled(isFreezingEnabled));
            }
        }
        catch (NullPointerException npe) {
            this.f_104888_.execute(() -> ClientPlayNetworkHandlerMixin.handleNPE(this.f_104888_.f_91074_));
        }
    }

    private static void handleNPE(LocalPlayer player) {
        SoulIceEnchantSyncer.setIsUnfalteringEnabled(SoulIceConfig.instance().enableUnfaltering);
        SoulIceEnchantSyncer.setIsFreezingEnabled(SoulIceConfig.instance().enableFreezing);
        SoulIceSlipSetter.soulIceSlip(SoulIceConfig.instance().slipperiness);
        player.m_108739_("Soul Ice Sync failed! Check log for more info. Please be cautious while playing");
        SoulIce.LOGGER.warn("Soul Ice Sync Packet null, continueing to play using client's configuration.");
        SoulIce.LOGGER.warn("If this error appeared, and the server runs Soul Ice, please contact the server owner.");
        SoulIce.LOGGER.warn("Otherwise, please send a bug report to https://github.com/Siuolthepic/Soul-Ice or talk to the mod's dev, Siuol.");
    }

    @Inject(method={"clearWorld"}, at={@At(value="HEAD")}, cancellable=true)
    private void soulIce$onClearWorld(CallbackInfo ci) {
        SoulIceEnchantSyncer.setIsUnfalteringEnabled(SoulIceConfig.instance().enableUnfaltering);
        SoulIceEnchantSyncer.setIsFreezingEnabled(SoulIceConfig.instance().enableFreezing);
        SoulIceSlipSetter.soulIceSlip(SoulIceConfig.instance().slipperiness);
    }
}

