/*
 * Decompiled with CFR 0.152.
 */
package io.siuolplex.soul_ice.forge.entries;

import io.siuolplex.soul_ice.SoulIce;
import io.siuolplex.soul_ice.block.SoulIceStairBlock;
import io.siuolplex.soul_ice.forge.registry.SoulIceItems;
import io.siuolplex.soul_ice.util.FalseBlock;
import java.util.Locale;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WoodButtonBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.registries.RegistryObject;

public class WoodRegistryEntrySet {
    public final String name;
    public final boolean makeLogs;
    public FalseBlock settingsBlock;

    public WoodRegistryEntrySet(String name, boolean makeLogs, BlockBehaviour.Properties blockSettings) {
        this.name = name;
        this.makeLogs = makeLogs;
        this.settingsBlock = new FalseBlock(blockSettings);
        for (PlankShapes shape : PlankShapes.values()) {
            WoodRegistryEntrySet.registerWithBlock(shape.withShape(this.name), this.blockRegistration(shape));
        }
    }

    public RegistryObject<Block> blockRegistration(PlankShapes shape) {
        String name = shape.withShape(this.name);
        return switch (shape) {
            default -> SoulIce.BLOCKS.register(name, () -> new Block(this.sharedSettings()));
            case PlankShapes.SLAB -> SoulIce.BLOCKS.register(name, () -> new SlabBlock(this.sharedSettings()));
            case PlankShapes.STAIRS -> SoulIce.BLOCKS.register(name, () -> new SoulIceStairBlock(Blocks.f_50705_.m_49966_(), this.sharedSettings()));
            case PlankShapes.FENCE -> SoulIce.BLOCKS.register(name, () -> new FenceBlock(this.sharedSettings()));
            case PlankShapes.FENCE_GATE -> SoulIce.BLOCKS.register(name, () -> new FenceGateBlock(this.sharedSettings()));
            case PlankShapes.PRESSURE_PLATE -> SoulIce.BLOCKS.register(name, () -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, this.sharedSettings()));
            case PlankShapes.BUTTON -> SoulIce.BLOCKS.register(name, () -> new WoodButtonBlock(this.sharedSettings()));
            case PlankShapes.DOOR -> SoulIce.BLOCKS.register(name, () -> new DoorBlock(this.sharedSettings().m_60955_()));
            case PlankShapes.TRAPDOOR -> SoulIce.BLOCKS.register(name, () -> new TrapDoorBlock(this.sharedSettings().m_60955_()));
        };
    }

    private static void registerWithBlock(String name, RegistryObject<Block> block) {
        SoulIce.ITEMS.register(name, () -> new BlockItem((Block)block.get(), SoulIceItems.sharedItemSettings()));
    }

    public BlockBehaviour.Properties sharedSettings() {
        return BlockBehaviour.Properties.m_60926_((BlockBehaviour)this.settingsBlock);
    }

    public static enum PlankShapes {
        BLOCK,
        SLAB,
        STAIRS,
        FENCE,
        FENCE_GATE,
        BUTTON,
        PRESSURE_PLATE,
        DOOR,
        TRAPDOOR;


        public String withShape(String name) {
            return name + (String)(this.equals((Object)BLOCK) ? "_planks" : "_plank_" + this);
        }

        public String toString() {
            if (this.equals((Object)BLOCK)) {
                return "";
            }
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

