/*
 * Decompiled with CFR 0.152.
 */
package io.siuolplex.soul_ice;

import io.siuolplex.soul_ice.SoulIceConfig;
import io.siuolplex.soul_ice.forge.registry.SoulIceBlocks;
import io.siuolplex.soul_ice.forge.registry.SoulIceEnchantments;
import io.siuolplex.soul_ice.forge.registry.SoulIceItems;
import io.siuolplex.soul_ice.forge.registry.SoulIceWorldGen;
import io.siuolplex.soul_ice.util.LoaderUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="soul_ice")
public class SoulIce {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"soul_ice");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"soul_ice");
    public static String id = "soul_ice";
    public static ResourceLocation unfalteringSyncID = SoulIce.idFormatter("unfaltering_sync");
    public static ResourceLocation freezingSyncID = SoulIce.idFormatter("freezing_sync");
    public static ResourceLocation soulIceSyncID = SoulIce.idFormatter("soul_ice_sync");
    public static Logger LOGGER = LogManager.getLogger((String)"Soul Ice");
    final ModLoadingContext modLoadingContext = ModLoadingContext.get();
    final IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();

    public static ResourceLocation idFormatter(String string) {
        return new ResourceLocation(id, string);
    }

    public SoulIce() {
        SoulIceBlocks.init();
        SoulIceItems.init();
        BLOCKS.register(this.modEventBus);
        ITEMS.register(this.modEventBus);
        SoulIceEnchantments.ENCHANTMENTS.register(this.modEventBus);
        IEventBus bus = MinecraftForge.EVENT_BUS;
        bus.addListener(SoulIce::onBiomeLoad);
        LoaderUtils.isForge = true;
    }

    public static void onBiomeLoad(BiomeLoadingEvent ble) {
        if (!ble.getCategory().equals((Object)Biome.BiomeCategory.THEEND) || !ble.getCategory().equals((Object)Biome.BiomeCategory.NETHER) && SoulIceConfig.instance().enableLightstoneGeneration) {
            ble.getGeneration().m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, SoulIceWorldGen.MTJSIPlacedFeatures.LIGHTSTONE);
        }
        if (ble.getCategory().equals((Object)Biome.BiomeCategory.PLAINS) && SoulIceConfig.instance().enableOrangeRoseGeneration) {
            ble.getGeneration().m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, SoulIceWorldGen.MTJSIPlacedFeatures.ORANGE_ROSE);
        }
        if (ble.getCategory().equals((Object)Biome.BiomeCategory.DESERT) && SoulIceConfig.instance().enableRujoneBerryGeneration) {
            ble.getGeneration().m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, SoulIceWorldGen.MTJSIPlacedFeatures.RUJONE_BERRY);
        }
    }

    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(SoulIceWorldGen::init);
    }
}

