/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.peripherals.peripherals;

import com.hakimen.peripherals.blocks.tile_entities.SpawnerInterfaceEntity;
import com.hakimen.peripherals.items.MobDataCardItem;
import com.hakimen.peripherals.utils.Utils;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpawnerPeripheral
implements IPeripheral {
    SpawnerInterfaceEntity entity;

    public SpawnerPeripheral(SpawnerInterfaceEntity entity) {
        this.entity = entity;
    }

    @NotNull
    public String getType() {
        return "spawner_interface";
    }

    public boolean equals(@Nullable IPeripheral other) {
        return other == this;
    }

    @LuaFunction
    public final boolean changeSpawner(IComputerAccess computer, String inv, int slot, Optional<Boolean> force) throws LuaException {
        --slot;
        IPeripheral peripheral = computer.getAvailablePeripheral(inv);
        if (inv == null) {
            throw new LuaException("the input " + inv + " was not found");
        }
        IItemHandler handler = SpawnerPeripheral.extractHandler(peripheral.getTarget());
        if (Utils.isFromMinecraft(computer, inv)) {
            if (slot < 0 || slot > handler.getSlots()) {
                throw new LuaException("Slot out of range");
            }
            ItemStack stack = handler.getStackInSlot(slot);
            if (stack.m_41782_() && stack.m_41720_() instanceof MobDataCardItem) {
                String previousMob = this.entity.entity.m_187480_().m_128469_("SpawnData").m_128469_("entity").m_128461_("id");
                this.entity.entity.m_59801_().m_45462_((EntityType)EntityType.m_20632_((String)stack.m_41783_().m_128461_("mob")).get());
                if (force.isPresent() && force.get().booleanValue()) {
                    stack.m_41783_().m_128473_("mob");
                } else if (!previousMob.equals("minecraft:pig")) {
                    stack.m_41783_().m_128359_("mob", previousMob);
                }
                stack.m_41787_();
                CompoundTag tag = new CompoundTag();
                CompoundTag saved = this.entity.entity.m_59801_().m_186381_(tag);
                this.entity.entity.m_59801_().m_151328_(this.entity.entity.m_58904_(), this.entity.entity.m_58899_(), saved);
                this.entity.entity.m_6596_();
                this.entity.entity.m_59801_().getSpawnerEntity();
                return true;
            }
        } else {
            throw new LuaException("This block requires a vanilla inventory");
        }
        return false;
    }

    @LuaFunction
    public final String getCurrentlySpawningMob() {
        CompoundTag tag = new CompoundTag();
        tag = this.entity.entity.m_59801_().m_186381_(tag);
        return tag.m_128469_("SpawnData").m_128469_("entity").m_128461_("id");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @LuaFunction
    public final boolean captureSpawner(IComputerAccess computer, Optional<String> inv, Optional<Integer> slot) throws LuaException {
        ItemStack spawnerBlock = new ItemStack((ItemLike)Items.f_42007_);
        CompoundTag tag = new CompoundTag();
        CompoundTag saved = this.entity.entity.m_59801_().m_186381_(tag);
        if (inv.isPresent()) {
            IPeripheral peripheral = computer.getAvailablePeripheral(inv.get());
            if (inv.get() == null) {
                throw new LuaException("the input " + inv.get() + " was not found");
            }
            IItemHandler handler = SpawnerPeripheral.extractHandler(peripheral.getTarget());
            if (!Utils.isFromMinecraft(computer, inv.get())) throw new LuaException("This block requires a vanilla inventory");
            if (!slot.isPresent()) return false;
            if ((slot = Optional.of(slot.get() - 1)).get() < 0 || slot.get() > handler.getSlots()) {
                throw new LuaException("Slot out of range");
            }
            ItemStack stack = handler.getStackInSlot(slot.get().intValue());
            if (!(stack.m_41720_() instanceof MobDataCardItem)) return false;
            stack.m_41784_().m_128359_("mob", saved.m_128469_("SpawnData").m_128469_("entity").m_128461_("id"));
            stack.m_41714_((Component)new TranslatableComponent("item.peripherals.mob_data_card").m_130946_(" (" + stack.m_41784_().m_128461_("mob") + ")"));
            BlockPos blockPos = this.entity.entity.m_58899_();
            this.entity.entity.m_58904_().m_7967_((Entity)new ItemEntity(this.entity.entity.m_58904_(), (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), spawnerBlock));
            this.entity.entity.m_58904_().m_46961_(blockPos, false);
            return true;
        }
        if (!saved.m_128469_("SpawnData").m_128469_("entity").m_128461_("id").equals("minecraft:pig")) return false;
        BlockPos blockPos = this.entity.entity.m_58899_();
        this.entity.entity.m_58904_().m_7967_((Entity)new ItemEntity(this.entity.entity.m_58904_(), (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), spawnerBlock));
        this.entity.entity.m_58904_().m_46961_(blockPos, false);
        return true;
    }

    @Nullable
    private static IItemHandler extractHandler(@Nullable Object object) {
        ICapabilityProvider provider;
        LazyOptional cap;
        BlockEntity blockEntity;
        if (object instanceof BlockEntity && (blockEntity = (BlockEntity)object).m_58901_()) {
            return null;
        }
        if (object instanceof ICapabilityProvider && (cap = (provider = (ICapabilityProvider)object).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)).isPresent()) {
            return (IItemHandler)cap.orElseThrow(NullPointerException::new);
        }
        if (object instanceof IItemHandler) {
            IItemHandler handler = (IItemHandler)object;
            return handler;
        }
        if (object instanceof Container) {
            Container container = (Container)object;
            return new InvWrapper(container);
        }
        return null;
    }
}

