/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.peripherals.peripherals;

import com.hakimen.peripherals.blocks.tile_entities.LoomInterfaceEntity;
import com.hakimen.peripherals.utils.Utils;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoomInterfacePeripheral
implements IPeripheral {
    private final LoomInterfaceEntity tileEntity;

    public LoomInterfacePeripheral(LoomInterfaceEntity tileEntity) {
        this.tileEntity = tileEntity;
    }

    @NotNull
    public String getType() {
        return "loom_interface";
    }

    public boolean equals(@Nullable IPeripheral other) {
        return other == this;
    }

    @LuaFunction
    public void paintBanner(IComputerAccess computer, String from, int slotBanner, int slotDye, int pattern) throws LuaException {
        if (!Utils.isFromMinecraft(computer, from)) {
            throw new LuaException("this method needs a vanilla inventory as input");
        }
        if (this.tileEntity.loom == null) {
            throw new LuaException("there is no loom near the interface");
        }
        IPeripheral inputPeripheral = computer.getAvailablePeripheral(from);
        if (inputPeripheral == null) {
            throw new LuaException("the input " + from + " was not found");
        }
        IItemHandler input = LoomInterfacePeripheral.extractHandler(inputPeripheral.getTarget());
        if (slotBanner < 0 || slotBanner > input.getSlots()) {
            throw new LuaException("banner slot out of range");
        }
        if (slotDye < 0 || slotDye > input.getSlots()) {
            throw new LuaException("dye slot out of range");
        }
        ItemStack banner = input.getStackInSlot(slotBanner);
        ItemStack dye = input.getStackInSlot(slotDye);
        if (!(banner.m_41720_() instanceof BannerItem)) {
            throw new LuaException("the item in " + slotBanner + " is not a banner");
        }
        if (!(dye.m_41720_() instanceof DyeItem)) {
            throw new LuaException("the item in " + slotDye + " is not a dye");
        }
        if (dye.m_41613_() < banner.m_41613_()) {
            throw new LuaException("not enough dye");
        }
        if (BannerPattern.values().length <= pattern || pattern < 0) {
            throw new LuaException("invalid pattern");
        }
        CompoundTag patternTag = new CompoundTag();
        patternTag.m_128365_("Pattern", (Tag)StringTag.m_129297_((String)BannerPattern.values()[pattern].m_58579_()));
        patternTag.m_128405_("Color", DyeColor.getColor((ItemStack)dye).m_41060_());
        input.extractItem(slotDye, banner.m_41613_(), false);
        ListTag ListPatterns = new ListTag();
        CompoundTag blockEntityData = BlockItem.m_186336_((ItemStack)banner);
        if (blockEntityData != null && blockEntityData.m_128425_("Patterns", 9)) {
            ListPatterns = blockEntityData.m_128437_("Patterns", 10);
        } else {
            ListPatterns = new ListTag();
            if (blockEntityData == null) {
                blockEntityData = new CompoundTag();
            }
            blockEntityData.m_128365_("Patterns", (Tag)ListPatterns);
        }
        ListPatterns.add((Object)patternTag);
        BlockItem.m_186338_((ItemStack)banner, (BlockEntityType)BlockEntityType.f_58935_, (CompoundTag)blockEntityData);
    }

    @LuaFunction
    public void clearBanner(IComputerAccess computer, String from, int slot) throws LuaException {
        if (this.tileEntity.loom == null) {
            throw new LuaException("there is no loom near the interface");
        }
        IPeripheral inputPeripheral = computer.getAvailablePeripheral(from);
        if (inputPeripheral == null) {
            throw new LuaException("the input " + from + " was not found");
        }
        IItemHandler input = LoomInterfacePeripheral.extractHandler(inputPeripheral.getTarget());
        if (slot < 0 || slot > input.getSlots()) {
            throw new LuaException("slot out of range");
        }
        ItemStack banner = input.getStackInSlot(slot);
        if (!(banner.m_41720_() instanceof BannerItem)) {
            throw new LuaException("not a banner");
        }
        BlockItem.m_186338_((ItemStack)banner, (BlockEntityType)BlockEntityType.f_58935_, (CompoundTag)new CompoundTag());
    }

    @javax.annotation.Nullable
    private static IItemHandler extractHandler(@javax.annotation.Nullable Object object) {
        ICapabilityProvider provider;
        LazyOptional cap;
        BlockEntity blockEntity;
        if (object instanceof BlockEntity && (blockEntity = (BlockEntity)object).m_58901_()) {
            return null;
        }
        if (object instanceof ICapabilityProvider && (cap = (provider = (ICapabilityProvider)object).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)).isPresent()) {
            return (IItemHandler)cap.orElseThrow(NullPointerException::new);
        }
        if (object instanceof IItemHandler) {
            IItemHandler handler = (IItemHandler)object;
            return handler;
        }
        if (object instanceof Container) {
            Container container = (Container)object;
            return new InvWrapper(container);
        }
        return null;
    }

    private static int moveItem(IItemHandler from, int fromSlot, IItemHandler to, int toSlot, int limit) {
        int inserted;
        ItemStack extracted = from.extractItem(fromSlot, limit, true);
        if (extracted.m_41619_()) {
            return 0;
        }
        int extractCount = Math.min(extracted.m_41613_(), limit);
        extracted.m_41764_(extractCount);
        ItemStack remainder = toSlot < 0 ? ItemHandlerHelper.insertItem((IItemHandler)to, (ItemStack)extracted, (boolean)false) : to.insertItem(toSlot, extracted, false);
        int n = inserted = remainder.m_41619_() ? extractCount : extractCount - remainder.m_41613_();
        if (inserted <= 0) {
            return 0;
        }
        from.extractItem(fromSlot, inserted, false);
        return inserted;
    }
}

