/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.peripherals.peripherals;

import com.hakimen.peripherals.blocks.tile_entities.GrindstoneInterfaceEntity;
import com.hakimen.peripherals.peripherals.XPCollectorPeripheral;
import com.hakimen.peripherals.utils.Utils;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GrindstonePeripheral
implements IPeripheral {
    private final GrindstoneInterfaceEntity tileEntity;

    public GrindstonePeripheral(GrindstoneInterfaceEntity tileEntity) {
        this.tileEntity = tileEntity;
    }

    @NotNull
    public String getType() {
        return "grindstone_interface";
    }

    public boolean equals(@Nullable IPeripheral other) {
        return other == this;
    }

    @LuaFunction
    public boolean combine(IComputerAccess computer, String from, int fromSlot, String resource, int resourceSlot) throws LuaException {
        if (!Utils.isFromMinecraft(computer, from)) {
            throw new LuaException("This method requires a vanilla inventory");
        }
        if (!Utils.isFromMinecraft(computer, resource)) {
            throw new LuaException("This method requires a vanilla inventory");
        }
        if (this.tileEntity.grindStone == null) {
            throw new LuaException("there is no grindstone near the interface");
        }
        if (from.matches(resource) && --fromSlot == --resourceSlot) {
            throw new LuaException("Can't combine item with itself");
        }
        IPeripheral input = computer.getAvailablePeripheral(from);
        if (input == null) {
            throw new LuaException("the input " + from + " was not found");
        }
        IItemHandler inputHandler = GrindstonePeripheral.extractHandler(input.getTarget());
        if (fromSlot < 0 || fromSlot > inputHandler.getSlots()) {
            throw new LuaException("from slot out of range");
        }
        ItemStack itemstack = inputHandler.getStackInSlot(fromSlot);
        IPeripheral resourcesInput = computer.getAvailablePeripheral(resource);
        if (resourcesInput == null) {
            throw new LuaException("the resources input " + resource + " was not found");
        }
        IItemHandler resourcesInputHandler = GrindstonePeripheral.extractHandler(resourcesInput.getTarget());
        if (resourceSlot < 0 || resourceSlot > resourcesInputHandler.getSlots()) {
            throw new LuaException("resource slot out of range");
        }
        ItemStack itemstack1 = resourcesInputHandler.getStackInSlot(resourceSlot);
        int j = 1;
        if (!itemstack.m_150930_(itemstack1.m_41720_())) {
            inputHandler.insertItem(fromSlot, itemstack, false);
            resourcesInputHandler.insertItem(resourceSlot, itemstack1, false);
            throw new LuaException("Items aren't the same type");
        }
        int k = itemstack.m_41776_() - itemstack.m_41773_();
        int l = itemstack.m_41776_() - itemstack1.m_41773_();
        int i1 = k + l + itemstack.m_41776_() * 5 / 100;
        int i = Math.max(itemstack.m_41776_() - i1, 0);
        ItemStack itemstack2 = this.mergeEnchants(itemstack, itemstack1);
        if (!itemstack2.isRepairable()) {
            i = itemstack.m_41773_();
        }
        if (!itemstack2.m_41763_() || !itemstack2.isRepairable()) {
            if (!ItemStack.m_41728_((ItemStack)itemstack, (ItemStack)itemstack1)) {
                inputHandler.insertItem(fromSlot, itemstack, false);
                resourcesInputHandler.insertItem(resourceSlot, itemstack1, false);
                throw new LuaException("items don't match");
            }
            j = 2;
        }
        inputHandler.extractItem(fromSlot, 1, false);
        resourcesInputHandler.extractItem(resourceSlot, 1, false);
        itemstack2.m_41721_(i);
        inputHandler.insertItem(fromSlot, itemstack2, false);
        return true;
    }

    @LuaFunction
    public void disenchant(IComputerAccess computer, String from, int slot, Optional<String> collector) throws LuaException {
        if (!Utils.isFromMinecraft(computer, from)) {
            throw new LuaException("This method requires a vanilla inventory");
        }
        if (this.tileEntity.grindStone == null) {
            throw new LuaException("there is no grindstone near the interface");
        }
        ++slot;
        IPeripheral input = computer.getAvailablePeripheral(from);
        if (input == null) {
            throw new LuaException("the input " + from + " was not found");
        }
        IItemHandler inputHandler = GrindstonePeripheral.extractHandler(input.getTarget());
        if (slot < 1 || slot > inputHandler.getSlots()) {
            throw new LuaException("slot out of range");
        }
        if (inputHandler.getStackInSlot(slot).m_150930_(Items.f_42690_)) {
            inputHandler.extractItem(slot, 1, false);
            inputHandler.insertItem(slot, Items.f_42517_.m_7968_(), false);
        } else {
            inputHandler.getStackInSlot(slot).m_41749_("Enchantments");
        }
        if (collector.isPresent()) {
            IPeripheral collectorInput = computer.getAvailablePeripheral(collector.get());
            XPCollectorPeripheral collectorPeripheral = (XPCollectorPeripheral)collectorInput;
            collectorPeripheral.tileEntity.xpPoints += 8;
        }
    }

    @javax.annotation.Nullable
    private static IItemHandler extractHandler(@javax.annotation.Nullable Object object) {
        ICapabilityProvider provider;
        LazyOptional cap;
        BlockEntity blockEntity;
        if (object instanceof BlockEntity && (blockEntity = (BlockEntity)object).m_58901_()) {
            return null;
        }
        if (object instanceof ICapabilityProvider && (cap = (provider = (ICapabilityProvider)object).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)).isPresent()) {
            return (IItemHandler)cap.orElseThrow(NullPointerException::new);
        }
        if (object instanceof IItemHandler) {
            IItemHandler handler = (IItemHandler)object;
            return handler;
        }
        if (object instanceof Container) {
            Container container = (Container)object;
            return new InvWrapper(container);
        }
        return null;
    }

    private static int moveItem(IItemHandler from, int fromSlot, IItemHandler to, int toSlot, int limit) {
        int inserted;
        ItemStack extracted = from.extractItem(fromSlot, limit, true);
        if (extracted.m_41619_()) {
            return 0;
        }
        int extractCount = Math.min(extracted.m_41613_(), limit);
        extracted.m_41764_(extractCount);
        ItemStack remainder = toSlot < 0 ? ItemHandlerHelper.insertItem((IItemHandler)to, (ItemStack)extracted, (boolean)false) : to.insertItem(toSlot, extracted, false);
        int n = inserted = remainder.m_41619_() ? extractCount : extractCount - remainder.m_41613_();
        if (inserted <= 0) {
            return 0;
        }
        from.extractItem(fromSlot, inserted, false);
        return inserted;
    }

    private ItemStack mergeEnchants(ItemStack p_39591_, ItemStack p_39592_) {
        ItemStack itemstack = p_39591_.m_41777_();
        Map map = EnchantmentHelper.m_44831_((ItemStack)p_39592_);
        for (Map.Entry entry : map.entrySet()) {
            Enchantment enchantment = (Enchantment)entry.getKey();
            if (enchantment.m_6589_() && EnchantmentHelper.m_44843_((Enchantment)enchantment, (ItemStack)itemstack) != 0) continue;
            itemstack.m_41663_(enchantment, ((Integer)entry.getValue()).intValue());
        }
        return itemstack;
    }

    private ItemStack removeNonCurses(ItemStack p_39580_, int p_39581_, int p_39582_) {
        ItemStack itemstack = p_39580_.m_41777_();
        itemstack.m_41749_("Enchantments");
        itemstack.m_41749_("StoredEnchantments");
        if (p_39581_ > 0) {
            itemstack.m_41721_(p_39581_);
        } else {
            itemstack.m_41749_("Damage");
        }
        itemstack.m_41764_(p_39582_);
        Map<Enchantment, Integer> map = EnchantmentHelper.m_44831_((ItemStack)p_39580_).entrySet().stream().filter(p_39584_ -> ((Enchantment)p_39584_.getKey()).m_6589_()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        EnchantmentHelper.m_44865_(map, (ItemStack)itemstack);
        itemstack.m_41742_(0);
        if (itemstack.m_150930_(Items.f_42690_) && map.size() == 0) {
            itemstack = new ItemStack((ItemLike)Items.f_42517_);
            if (p_39580_.m_41788_()) {
                itemstack.m_41714_(p_39580_.m_41786_());
            }
        }
        for (int i = 0; i < map.size(); ++i) {
            itemstack.m_41742_(AnvilMenu.m_39025_((int)itemstack.m_41610_()));
        }
        return itemstack;
    }
}

