/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.peripherals.peripherals;

import com.hakimen.peripherals.blocks.tile_entities.GrinderEntity;
import com.mojang.authlib.GameProfile;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.List;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GrinderPeripheral
implements IPeripheral {
    private final GrinderEntity tileEntity;
    private final FakePlayer fakePlayer;

    public GrinderPeripheral(GrinderEntity tileEntity) {
        this.tileEntity = tileEntity;
        this.fakePlayer = new FakePlayer((ServerLevel)tileEntity.m_58904_(), new GameProfile(UUID.randomUUID(), "Grinder"));
    }

    @NotNull
    public String getType() {
        return "grinder";
    }

    public boolean equals(@Nullable IPeripheral other) {
        return other == this;
    }

    @LuaFunction(mainThread=true)
    public final void attack() {
        List entities = this.tileEntity.m_58904_().m_45933_(null, new AABB(this.tileEntity.m_58899_().m_7495_().m_142127_().m_142385_(2), this.tileEntity.m_58899_().m_6630_(2).m_142383_(2).m_142386_(2)));
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            this.fakePlayer.m_21008_(InteractionHand.MAIN_HAND, this.tileEntity.inventory.getStackInSlot(0));
            this.fakePlayer.m_5706_(entity);
            livingEntity.f_19802_ = 0;
            Item item = this.tileEntity.inventory.getStackInSlot(0).m_41720_();
            if (!(item instanceof SwordItem)) continue;
            SwordItem sword = (SwordItem)item;
            livingEntity.m_6469_(DamageSource.m_19344_((Player)this.fakePlayer), sword.m_43299_());
        }
    }

    @LuaFunction
    public final boolean hasSword() {
        return this.tileEntity.inventory.getStackInSlot(0).m_41720_() instanceof SwordItem;
    }

    @LuaFunction
    public final boolean pushSword(IComputerAccess computer, String from, int slot) throws LuaException {
        IPeripheral input = computer.getAvailablePeripheral(from);
        if (input == null) {
            throw new LuaException("the input " + from + " was not found");
        }
        IItemHandler inputHandler = GrinderPeripheral.extractHandler(input.getTarget());
        if (slot < 0 || slot > inputHandler.getSlots()) {
            throw new LuaException("slot out of range");
        }
        ItemStack stack = inputHandler.getStackInSlot(slot);
        if (stack.m_41720_() instanceof SwordItem) {
            if (!(this.tileEntity.inventory.getStackInSlot(0).m_41720_() instanceof SwordItem)) {
                this.tileEntity.inventory.setStackInSlot(0, stack.m_41777_());
                inputHandler.extractItem(slot, 1, false);
                return true;
            }
            throw new LuaException("there is a sword in the grinder already");
        }
        return false;
    }

    @LuaFunction
    public final void pullSword(IComputerAccess computer, String to) throws LuaException {
        IPeripheral input = computer.getAvailablePeripheral(to);
        if (input == null) {
            throw new LuaException("the output " + to + " was not found");
        }
        IItemHandler inputHandler = GrinderPeripheral.extractHandler(input.getTarget());
        ItemStack stack = this.tileEntity.inventory.getStackInSlot(0).m_41777_();
        boolean sent = false;
        for (int i = 0; i < inputHandler.getSlots(); ++i) {
            if (!inputHandler.getStackInSlot(i).m_41619_()) continue;
            inputHandler.insertItem(i, stack, false);
            this.tileEntity.inventory.extractItem(0, 1, false);
            sent = true;
            break;
        }
        if (!sent) {
            throw new LuaException("target inventory is full");
        }
    }

    @javax.annotation.Nullable
    private static IItemHandler extractHandler(@javax.annotation.Nullable Object object) {
        ICapabilityProvider provider;
        LazyOptional cap;
        BlockEntity blockEntity;
        if (object instanceof BlockEntity && (blockEntity = (BlockEntity)object).m_58901_()) {
            return null;
        }
        if (object instanceof ICapabilityProvider && (cap = (provider = (ICapabilityProvider)object).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)).isPresent()) {
            return (IItemHandler)cap.orElseThrow(NullPointerException::new);
        }
        if (object instanceof IItemHandler) {
            IItemHandler handler = (IItemHandler)object;
            return handler;
        }
        if (object instanceof Container) {
            Container container = (Container)object;
            return new InvWrapper(container);
        }
        return null;
    }
}

