/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.peripherals.peripherals;

import com.hakimen.peripherals.blocks.tile_entities.EnchantingTableInterfaceEntity;
import com.hakimen.peripherals.utils.EnchantUtils;
import com.hakimen.peripherals.utils.Utils;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.world.Container;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnchantingTablePeripheral
implements IPeripheral {
    private final EnchantingTableInterfaceEntity tileEntity;

    public EnchantingTablePeripheral(EnchantingTableInterfaceEntity tileEntity) {
        this.tileEntity = tileEntity;
    }

    @NotNull
    public String getType() {
        return "enchanting_interface";
    }

    public boolean equals(@Nullable IPeripheral other) {
        return other == this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @LuaFunction
    public List<String> getEnchantsFor(IComputerAccess computer, String from, int slot) throws LuaException {
        if (this.tileEntity.enchantTable == null) {
            throw new LuaException("there is no enchanting table near the interface");
        }
        ArrayList<String> enchants = new ArrayList<String>();
        IPeripheral input = computer.getAvailablePeripheral(from);
        if (input == null) {
            throw new LuaException("the input " + from + " was not found");
        }
        IItemHandler inputHandler = EnchantingTablePeripheral.extractHandler(input.getTarget());
        if (slot < 0 || slot > inputHandler.getSlots()) {
            throw new LuaException("slot out of range");
        }
        if (this.tileEntity.enchantTable == null) {
            throw new LuaException("there is no enchanting table near the interface");
        }
        ItemStack item = inputHandler.getStackInSlot(slot);
        if (!item.m_41792_()) throw new LuaException("this item can not be enchanted");
        if (item.m_41793_()) throw new LuaException("this item is already enchanted");
        for (EnchantmentCategory category : EnchantmentCategory.values()) {
            for (Enchantment e : Registry.f_122825_) {
                if (e.f_44672_ != category || !e.canApplyAtEnchantingTable(item) || e.m_6591_()) continue;
                enchants.add(e.m_44704_());
            }
        }
        return enchants;
    }

    @LuaFunction
    public boolean enchant(IComputerAccess computer, String from, int slot, String resources) throws LuaException {
        if (!Utils.isFromMinecraft(computer, resources)) {
            throw new LuaException("this method needs a vanilla inventory as the resources input");
        }
        if (this.tileEntity.enchantTable == null) {
            throw new LuaException("there is no enchanting table near the interface");
        }
        int bottlesNeeded = 8;
        IPeripheral input = computer.getAvailablePeripheral(from);
        if (input == null) {
            throw new LuaException("the input " + from + " was not found");
        }
        IItemHandler inputHandler = EnchantingTablePeripheral.extractHandler(input.getTarget());
        if (slot < 0 || slot > inputHandler.getSlots()) {
            throw new LuaException("slot out of range");
        }
        IPeripheral resourcesInput = computer.getAvailablePeripheral(resources);
        if (resourcesInput == null) {
            throw new LuaException("the resources input " + resources + " was not found");
        }
        IItemHandler resourcesInputHandler = EnchantingTablePeripheral.extractHandler(resourcesInput.getTarget());
        boolean foundLapis = false;
        boolean foundEXP = false;
        int lapisSlot = -1;
        int expSlot = -1;
        for (int i = 0; i < resourcesInputHandler.getSlots(); ++i) {
            if (!foundLapis && resourcesInputHandler.getStackInSlot(i).m_150930_(Items.f_42534_) && resourcesInputHandler.getStackInSlot(i).m_41613_() >= 1) {
                lapisSlot = i;
                foundLapis = true;
            }
            if (foundEXP || !resourcesInputHandler.getStackInSlot(i).m_150930_(Items.f_42612_) || resourcesInputHandler.getStackInSlot(i).m_41613_() < bottlesNeeded) continue;
            expSlot = i;
            foundEXP = true;
        }
        if (!foundEXP) {
            throw new LuaException("not found the required " + bottlesNeeded + " xp bottles");
        }
        if (!foundLapis) {
            throw new LuaException("not found the required lapis lazuli");
        }
        if (foundEXP && foundLapis) {
            resourcesInputHandler.extractItem(lapisSlot, 1, false);
            resourcesInputHandler.extractItem(expSlot, bottlesNeeded, false);
            ItemStack item = inputHandler.getStackInSlot(slot);
            boolean isBook = item.m_41720_() == Items.f_42517_;
            ItemStack bookItem = item.m_41777_();
            if (isBook) {
                Optional enchant = Registry.f_122825_.m_203454_(this.tileEntity.m_58904_().f_46441_);
                if (enchant.isPresent()) {
                    int value = this.tileEntity.m_58904_().f_46441_.nextInt(((Enchantment)((Holder)enchant.get()).m_203334_()).m_44702_(), ((Enchantment)((Holder)enchant.get()).m_203334_()).m_6586_() + 1);
                    bookItem = EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance((Enchantment)((Holder)enchant.get()).m_203334_(), value));
                    if (item.m_41613_() > 1) {
                        boolean putBook = false;
                        for (int i = 0; i < inputHandler.getSlots(); ++i) {
                            if (inputHandler.getStackInSlot(i) != ItemStack.f_41583_) continue;
                            inputHandler.insertItem(i, bookItem, false);
                            putBook = true;
                            break;
                        }
                        if (!putBook) {
                            return false;
                        }
                    } else {
                        inputHandler.insertItem(slot, bookItem, false);
                    }
                    inputHandler.extractItem(slot, 1, false);
                } else {
                    this.enchant(computer, from, slot, resources);
                }
                return true;
            }
            if (!item.m_41793_()) {
                if (item.m_41792_()) {
                    EnchantUtils.addRandomEnchant(new Random(), item);
                    return true;
                }
                throw new LuaException("this item is not enchatable");
            }
            throw new LuaException("this item is already enchanted");
        }
        return false;
    }

    @javax.annotation.Nullable
    private static IItemHandler extractHandler(@javax.annotation.Nullable Object object) {
        ICapabilityProvider provider;
        LazyOptional cap;
        BlockEntity blockEntity;
        if (object instanceof BlockEntity && (blockEntity = (BlockEntity)object).m_58901_()) {
            return null;
        }
        if (object instanceof ICapabilityProvider && (cap = (provider = (ICapabilityProvider)object).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)).isPresent()) {
            return (IItemHandler)cap.orElseThrow(NullPointerException::new);
        }
        if (object instanceof IItemHandler) {
            IItemHandler handler = (IItemHandler)object;
            return handler;
        }
        if (object instanceof Container) {
            Container container = (Container)object;
            return new InvWrapper(container);
        }
        return null;
    }

    private static int moveItem(IItemHandler from, int fromSlot, IItemHandler to, int toSlot, int limit) {
        int inserted;
        ItemStack extracted = from.extractItem(fromSlot, limit, true);
        if (extracted.m_41619_()) {
            return 0;
        }
        int extractCount = Math.min(extracted.m_41613_(), limit);
        extracted.m_41764_(extractCount);
        ItemStack remainder = toSlot < 0 ? ItemHandlerHelper.insertItem((IItemHandler)to, (ItemStack)extracted, (boolean)false) : to.insertItem(toSlot, extracted, false);
        int n = inserted = remainder.m_41619_() ? extractCount : extractCount - remainder.m_41613_();
        if (inserted <= 0) {
            return 0;
        }
        from.extractItem(fromSlot, inserted, false);
        return inserted;
    }
}

