/*
 * Decompiled with CFR 0.152.
 */
package com.hakimen.peripherals.peripherals;

import com.hakimen.peripherals.blocks.tile_entities.DiskRaidEntity;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.MediaProviders;
import dan200.computercraft.shared.media.items.ItemDisk;
import dan200.computercraft.shared.util.StringUtil;
import java.util.Optional;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiskRaidPeripheral
implements IPeripheral {
    private final DiskRaidEntity tileEntity;

    public DiskRaidPeripheral(DiskRaidEntity tileEntity) {
        this.tileEntity = tileEntity;
    }

    @NotNull
    public String getType() {
        return "disk_raid";
    }

    public boolean equals(@Nullable IPeripheral other) {
        return other == this;
    }

    public void attach(@NotNull IComputerAccess computer) {
        for (int i = 0; i < 5; ++i) {
            this.tileEntity.mount(i, computer);
        }
        super.attach(computer);
    }

    public void detach(@NotNull IComputerAccess computer) {
        for (int i = 0; i < 5; ++i) {
            this.tileEntity.unmount(i, computer);
        }
        super.detach(computer);
    }

    @LuaFunction
    public final boolean isDiskPresent(int slot) {
        return !this.tileEntity.inventory.getStackInSlot(slot - 1).m_41619_();
    }

    @LuaFunction
    public final Object[] getDiskLabel(int slot) {
        Object[] objectArray;
        ItemStack stack = this.tileEntity.inventory.getStackInSlot(slot - 1);
        IMedia media = MediaProviders.get((ItemStack)stack);
        if (media == null) {
            objectArray = null;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = media.getLabel(stack);
        }
        return objectArray;
    }

    @LuaFunction(mainThread=true)
    public final void setDiskLabel(int slot, Optional<String> labelA) throws LuaException {
        String label = labelA.orElse(null);
        ItemStack stack = this.tileEntity.inventory.getStackInSlot(slot - 1);
        IMedia media = MediaProviders.get((ItemStack)stack);
        if (media == null) {
            return;
        }
        if (!media.setLabel(stack, StringUtil.normaliseLabel((String)label))) {
            throw new LuaException("Disk label cannot be changed");
        }
        this.tileEntity.inventory.extractItem(slot - 1, 1, false);
        this.tileEntity.inventory.insertItem(slot - 1, stack, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LuaFunction
    public final boolean hasData(int mount, IComputerAccess computer) {
        DiskRaidPeripheral diskRaidPeripheral = this;
        synchronized (diskRaidPeripheral) {
            DiskRaidEntity.MountInfo info = this.tileEntity.computers.get(computer);
            return (info != null ? info.mountPaths[mount] : null) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LuaFunction
    @javax.annotation.Nullable
    public final String getMountPath(int mount, IComputerAccess computer) {
        DiskRaidPeripheral diskRaidPeripheral = this;
        synchronized (diskRaidPeripheral) {
            DiskRaidEntity.MountInfo info = this.tileEntity.computers.get(computer);
            return info != null ? info.mountPaths[mount] : null;
        }
    }

    @LuaFunction
    public final void ejectDisk(int slot) {
        this.tileEntity.m_58904_().m_7967_((Entity)new ItemEntity(this.tileEntity.m_58904_(), (double)this.tileEntity.m_58899_().m_123341_(), (double)this.tileEntity.m_58899_().m_123342_(), (double)this.tileEntity.m_58899_().m_123343_(), this.tileEntity.inventory.extractItem(slot - 1, 1, false)));
    }

    @LuaFunction
    public final Object[] getDiskID(int slot) {
        Object[] objectArray;
        ItemStack disk = this.tileEntity.inventory.getStackInSlot(slot);
        if (disk.m_41720_() instanceof ItemDisk) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = ItemDisk.getDiskID((ItemStack)disk);
        } else {
            objectArray = null;
        }
        return objectArray;
    }

    @javax.annotation.Nullable
    private static IItemHandler extractHandler(@javax.annotation.Nullable Object object) {
        ICapabilityProvider provider;
        LazyOptional cap;
        BlockEntity blockEntity;
        if (object instanceof BlockEntity && (blockEntity = (BlockEntity)object).m_58901_()) {
            return null;
        }
        if (object instanceof ICapabilityProvider && (cap = (provider = (ICapabilityProvider)object).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)).isPresent()) {
            return (IItemHandler)cap.orElseThrow(NullPointerException::new);
        }
        if (object instanceof IItemHandler) {
            IItemHandler handler = (IItemHandler)object;
            return handler;
        }
        if (object instanceof Container) {
            Container container = (Container)object;
            return new InvWrapper(container);
        }
        return null;
    }
}

