/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups.de.piegames.nbt;

import java.util.Optional;
import net.creeperhost.ftbbackups.de.piegames.nbt.Tag;
import net.creeperhost.ftbbackups.de.piegames.nbt.TagType;

public final class ByteTag
extends Tag<Byte> {
    private byte value;

    public ByteTag(String name, boolean value) {
        this(name, (byte)(value ? 1 : 0));
    }

    public ByteTag(String name, byte value) {
        super(TagType.TAG_BYTE, name);
        this.value = value;
    }

    @Override
    public Byte getValue() {
        return this.value;
    }

    @Override
    public void setValue(Byte value) {
        this.value = value;
    }

    public boolean getBooleanValue() {
        return this.value != 0;
    }

    @Override
    public Optional<ByteTag> getAsByteTag() {
        return Optional.of(this);
    }

    public String toString() {
        String name = this.getName();
        String append = "";
        if (name != null && !name.equals("")) {
            append = "(\"" + this.getName() + "\")";
        }
        return "TAG_Byte" + append + ": " + this.value;
    }

    @Override
    public ByteTag clone() {
        return new ByteTag(this.getName(), this.value);
    }

    public static Boolean getBooleanValue(Tag<?> t) {
        if (t == null) {
            return null;
        }
        try {
            ByteTag byteTag = (ByteTag)t;
            return byteTag.getBooleanValue();
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.value;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ByteTag other = (ByteTag)obj;
        return this.value == other.value;
    }
}

