/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups.de.piegames.blockmap.standalone;

import com.google.gson.annotations.SerializedName;
import java.nio.file.Path;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.creeperhost.ftbbackups.de.piegames.blockmap.MinecraftDimension;
import net.creeperhost.ftbbackups.de.piegames.blockmap.renderer.RenderSettings;
import net.creeperhost.ftbbackups.de.piegames.blockmap.standalone.DeserializeNullChecker;
import net.creeperhost.ftbbackups.de.piegames.blockmap.world.LevelMetadata;
import net.creeperhost.ftbbackups.de.piegames.blockmap.world.ServerMetadata;

public class ServerSettings {
    public RegionFolderSettings[] worlds = new RegionFolderSettings[0];
    @SerializedName(value="output dir")
    @DeserializeNullChecker.DeserializeNonNull
    public Path outputDir;
    @SerializedName(value="server")
    public Optional<ServerMetadata> serverMetadata = Optional.empty();
    @SerializedName(value="show pins")
    public Optional<PinSettings> pinSettings = Optional.empty();

    public static class RegionFolderSettings {
        @DeserializeNullChecker.DeserializeNonNull
        public String name;
        @SerializedName(value="input dir")
        @DeserializeNullChecker.DeserializeNonNull
        public Path inputDir;
        public MinecraftDimension dimension = MinecraftDimension.OVERWORLD;
        public boolean force = false;
        @SerializedName(value="render settings")
        public RenderSettings renderSettings = new RenderSettings();
    }

    public static class PinSettings {
        @SerializedName(value="players")
        public ShowPlayers showPlayers = ShowPlayers.ALL;
        @SerializedName(value="maps")
        public boolean showMaps = true;
        @SerializedName(value="slime chunks")
        public boolean showSlimeChunks = true;
        @SerializedName(value="force-loaded chunks")
        public boolean showLoadedChunks = true;
        @SerializedName(value="barrier")
        public boolean showBarrier = true;
        @SerializedName(value="world spawn")
        public boolean showWorldSpawn = true;
        @SerializedName(value="POIs")
        public Optional<Set<String>> showPOIs = Optional.empty();
        @SerializedName(value="structures")
        public Optional<Set<String>> showStructures = Optional.empty();

        public LevelMetadata apply(LevelMetadata metadata, Set<String> onlinePlayers) {
            return new LevelMetadata(metadata.getWorldName(), metadata.getPlayers().flatMap(players -> {
                switch (this.showPlayers) {
                    case ALL: {
                        return Optional.of(players);
                    }
                    case ONLINE_ONLY: {
                        return Optional.of(players.stream().filter(player -> player.getUUID().map(onlinePlayers::contains).orElse(true)).collect(Collectors.toList()));
                    }
                    case NONE: {
                        return Optional.empty();
                    }
                }
                throw new InternalError();
            }), metadata.getMaps().filter(__ -> this.showMaps), metadata.getVillageObjects().map(pins -> {
                if (this.showPOIs.isEmpty()) {
                    return pins;
                }
                Set<String> showPOIs = this.showPOIs.get();
                return pins.stream().filter(pin -> showPOIs.contains(pin.getType())).collect(Collectors.toList());
            }), metadata.getSlimeChunks().filter(__ -> this.showSlimeChunks), metadata.getLoadedChunks().filter(__ -> this.showLoadedChunks), metadata.getBarrier().filter(__ -> this.showBarrier), metadata.getWorldSpawn().filter(__ -> this.showBarrier));
        }

        public static enum ShowPlayers {
            ALL,
            ONLINE_ONLY,
            NONE;

        }
    }
}

