/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups.de.piegames.blockmap.standalone;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.SerializedName;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.util.ArrayList;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.io.gsonfire.PostProcessor;

public class DeserializeNullChecker
implements PostProcessor<Object> {
    @Override
    public void postDeserialize(Object result, JsonElement src, Gson gson) {
        this.check(result, src);
    }

    @Override
    public void postSerialize(JsonElement result, Object src, Gson gson) {
    }

    private void check(Object result, JsonElement src) {
        try {
            ArrayList<CallSite> nullFields = new ArrayList<CallSite>();
            for (Field f : result.getClass().getDeclaredFields()) {
                if (!f.isAnnotationPresent(DeserializeNonNull.class)) continue;
                String name = f.getName();
                if (f.isAnnotationPresent(SerializedName.class)) {
                    name = f.getAnnotation(SerializedName.class).value();
                }
                if (f.get(result) != null) continue;
                nullFields.add((CallSite)((Object)("\"" + name + "\"")));
            }
            if (!nullFields.isEmpty()) {
                if (nullFields.size() == 1) {
                    throw new JsonParseException("Field " + (String)nullFields.get(0) + " in object '" + this.ellipsisString(src.toString()) + "' must be specified");
                }
                throw new JsonParseException("Fields " + nullFields + " in object '" + this.ellipsisString(src.toString()) + "' must be specified");
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new JsonParseException("Could not check all null fields", (Throwable)e);
        }
    }

    private String ellipsisString(String text) {
        if (text.length() < 40) {
            return text;
        }
        return text.substring(0, 30) + "[\u2026]" + text.substring(text.length() - 10, text.length());
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface DeserializeNonNull {
    }
}

