/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups.de.piegames.blockmap.repack.net.dongilu.gson;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQuery;
import java.util.Objects;

public class Java8TimeAdapter<T extends TemporalAccessor>
extends TypeAdapter<T> {
    private final DateTimeFormatter readFormatter;
    private final DateTimeFormatter writeFormatter;
    private final TemporalQuery<T> temporalQuery;

    public Java8TimeAdapter(DateTimeFormatter formatter, TemporalQuery<T> temporalQuery) {
        this(formatter, formatter, temporalQuery);
    }

    public Java8TimeAdapter(DateTimeFormatter readFormatter, DateTimeFormatter writeFormatter, TemporalQuery<T> temporalQuery) {
        this.readFormatter = Objects.requireNonNull(readFormatter);
        this.writeFormatter = Objects.requireNonNull(writeFormatter);
        this.temporalQuery = temporalQuery;
    }

    public void write(JsonWriter out, T value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        String str = this.writeFormatter.format((TemporalAccessor)value);
        out.value(str);
    }

    public T read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        String str = in.nextString();
        return (T)((TemporalAccessor)this.readFormatter.parse((CharSequence)str, this.temporalQuery));
    }
}

