/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups.de.piegames.blockmap.renderer;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.creeperhost.ftbbackups.de.piegames.blockmap.MinecraftVersion;
import net.creeperhost.ftbbackups.de.piegames.blockmap.color.BiomeColorMap;
import net.creeperhost.ftbbackups.de.piegames.blockmap.color.BlockColorMap;
import net.creeperhost.ftbbackups.de.piegames.blockmap.color.Color;
import net.creeperhost.ftbbackups.de.piegames.blockmap.renderer.ChunkRenderer;
import net.creeperhost.ftbbackups.de.piegames.blockmap.renderer.RenderSettings;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.org.joml.Vector2ic;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.org.joml.Vector3i;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.org.joml.Vector3ic;
import net.creeperhost.ftbbackups.de.piegames.blockmap.world.ChunkMetadata;
import net.creeperhost.ftbbackups.de.piegames.nbt.CompoundMap;
import net.creeperhost.ftbbackups.de.piegames.nbt.CompoundTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.ListTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.Tag;
import net.creeperhost.ftbbackups.de.piegames.nbt.regionfile.Chunk;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class ChunkRenderer_1_17
extends ChunkRenderer {
    private static Logger log = LogManager.getLogger(ChunkRenderer_1_17.class);

    public ChunkRenderer_1_17(RenderSettings settings) {
        super(MinecraftVersion.MC_1_17, settings);
    }

    @Override
    ChunkMetadata renderChunk(Vector2ic chunkPosRegion, Vector2ic chunkPosWorld, CompoundTag level, Color[] map, int[] height, String[] regionBiomes) {
        this.blockColors = this.settings.blockColors.get((Object)this.version);
        if (this.settings.minY < 0) {
            Arrays.fill(height, 0);
        }
        try {
            String generationStatus = level.getAsStringTag("Status").map(Tag::getValue).orElse("empty");
            if (ChunkMetadata.ChunkMetadataRendered.STATUS_EMPTY.contains(generationStatus)) {
                return new ChunkMetadata.ChunkMetadataRendered(chunkPosWorld, generationStatus);
            }
            HashMap<String, Vector3ic> structureCenters = new HashMap<String, Vector3ic>();
            level.getAsCompoundTag("Structures").flatMap(t -> t.getAsCompoundTag("Starts")).stream().flatMap(tag -> tag.getValue().values().stream()).map(Tag::getAsCompoundTag).flatMap(structure -> structure.stream()).forEach(structure2 -> {
                String id = structure2.getStringValue("id").orElse("INVALID");
                if (id.equals("INVALID")) {
                    return;
                }
                Stream.of(structure2).flatMap(structure -> structure.getAsListTag("Children").stream()).flatMap(children -> children.getAsCompoundTagList().stream()).flatMap(children -> children.getValue().stream()).filter(child -> child.getIntValue("GD").map(gd -> gd == 0).orElse(false)).forEach(child -> {
                    int[] bb = child.getIntArrayValue("BB").get();
                    Vector3i center = new Vector3i(bb[0], bb[1], bb[2]).add(bb[3], bb[4], bb[5]);
                    center.x /= 2;
                    center.y /= 2;
                    center.z /= 2;
                    structureCenters.put(id, center);
                });
            });
            String[] biomes = level.getIntArrayValue("Biomes").filter(b -> ((int[])b).length > 0).map(ints -> {
                String[] strings = new String[1024];
                for (int i = 0; i < 1024; ++i) {
                    strings[i] = Integer.toString(ints[i]);
                }
                return strings;
            }).orElse(new String[1024]);
            int lowestLoadedSection = 16;
            BlockColorMap.BlockColor[][] loadedSections = new BlockColorMap.BlockColor[16][];
            Map<Byte, CompoundMap> sections = level.getAsListTag("Sections").flatMap(ListTag::getAsCompoundTagList).map(ListTag::getValue).stream().flatMap(Collection::stream).collect(Collectors.toMap(section -> section.getByteValue("Y").get(), Tag::getValue));
            boolean mayCull = chunkPosWorld.x() << 4 < this.settings.minX || (chunkPosWorld.x() << 4) + 16 > this.settings.maxX || chunkPosWorld.y() << 4 < this.settings.minZ || (chunkPosWorld.y() << 4) + 16 > this.settings.maxZ;
            for (int z = 0; z < 16; z = (int)((byte)(z + 1))) {
                for (int x = 0; x < 16; x = (int)((byte)(x + 1))) {
                    if (mayCull && (x + (chunkPosWorld.x() << 4) < this.settings.minX || x + (chunkPosWorld.x() << 4) > this.settings.maxX || z + (chunkPosWorld.y() << 4) < this.settings.minZ || z + (chunkPosWorld.y() << 4) > this.settings.maxZ)) continue;
                    int xz = x | z << 4;
                    int biomeXZ = z & 0xC | x >> 2;
                    int regionXZ = chunkPosRegion.x() << 4 | x | chunkPosRegion.y() << 13 | z << 9;
                    boolean heightSet = false;
                    boolean discardTop = this.blockColors.isCaveView();
                    class ColorColumn {
                        Color color = Color.TRANSPARENT;
                        BlockColorMap.BlockColor lastColor = BlockColorMap.BlockColor.TRANSPARENT;
                        String lastBiome = null;
                        int lastColorTimes = 0;
                        boolean needStop = false;

                        ColorColumn() {
                        }

                        void putColor(BlockColorMap.BlockColor currentColor, int times, String biome) {
                            if (currentColor == this.lastColor && biome == this.lastBiome) {
                                this.lastColorTimes += times;
                            } else {
                                Color color = this.lastColor.color;
                                BiomeColorMap.BiomeColor biomeColor = ChunkRenderer_1_17.this.settings.biomeColors.getBiomeColor(this.lastBiome);
                                if (this.lastColor.isGrass) {
                                    color = Color.multiplyRGB(color, biomeColor.grassColor);
                                }
                                if (this.lastColor.isFoliage) {
                                    color = Color.multiplyRGB(color, biomeColor.foliageColor);
                                }
                                if (this.lastColor.isWater) {
                                    color = Color.multiplyRGB(color, biomeColor.waterColor);
                                }
                                this.color = Color.alphaUnder(this.color, color, this.lastColorTimes);
                                this.lastColorTimes = times;
                                this.lastColor = currentColor;
                                this.lastBiome = biome;
                                if ((double)currentColor.color.a > 0.9999) {
                                    this.needStop = true;
                                }
                            }
                        }

                        Color getFinal() {
                            this.putColor(BlockColorMap.BlockColor.TRANSPARENT, 1, null);
                            return this.color;
                        }
                    }
                    ColorColumn color = new ColorColumn();
                    block6: for (int s = 15; s >= 0; s = (int)((byte)(s - 1))) {
                        if (s << 4 > this.settings.maxY) continue;
                        if (s < lowestLoadedSection) {
                            try {
                                loadedSections[s] = this.renderSection(sections.get((byte)s), this.blockColors);
                            }
                            catch (Exception e) {
                                log.warn("Failed to render chunk (" + chunkPosRegion.x() + ", " + chunkPosRegion.y() + ") section " + (byte)s + ". This is very likely because your chunk is corrupt. If possible, please verify it manually before sending a bug report.", (Throwable)e);
                                return new ChunkMetadata.ChunkMetadataFailed(chunkPosWorld, e);
                            }
                            lowestLoadedSection = s;
                        }
                        if (loadedSections[s] == null) {
                            color.putColor(this.blockColors.getAirColor(), 16, null);
                            discardTop = false;
                            continue;
                        }
                        for (int y = 15; y >= 0; --y) {
                            int h = s << 4 | y;
                            if (h < this.settings.minY) break block6;
                            if (h > this.settings.maxY) continue;
                            int xzy = xz | y << 8;
                            BlockColorMap.BlockColor colorData = loadedSections[s][xzy];
                            if (discardTop && colorData.isTranslucent) {
                                discardTop = false;
                            }
                            if (!(discardTop || colorData.isTranslucent || heightSet)) {
                                height[regionXZ] = h;
                                heightSet = true;
                            }
                            int biomeXYZ = h >> 2 << 4 | biomeXZ;
                            if (!discardTop) {
                                color.putColor(colorData, 1, biomes[biomeXYZ]);
                            }
                            if (color.needStop) break block6;
                        }
                    }
                    regionBiomes[regionXZ] = biomes[height[regionXZ] >> 2 << 4 | biomeXZ];
                    map[regionXZ] = color.getFinal();
                }
            }
            return new ChunkMetadata.ChunkMetadataRendered(chunkPosWorld, generationStatus, structureCenters);
        }
        catch (Exception e) {
            log.warn("Failed to render chunk (" + chunkPosRegion.x() + ", " + chunkPosRegion.y() + ")", (Throwable)e);
            return new ChunkMetadata.ChunkMetadataFailed(chunkPosWorld, e);
        }
    }

    private BlockColorMap.BlockColor[] renderSection(CompoundMap section, BlockColorMap blockColors) {
        if (section == null || !section.containsKey("Palette")) {
            return null;
        }
        List palette = ((Tag)section.get("Palette")).getAsListTag().flatMap(ListTag::getAsCompoundTagList).map(Tag::getValue).stream().flatMap(Collection::stream).map(map -> blockColors.getBlockColor(map.getStringValue("Name").get(), () -> ChunkRenderer_1_17.parseBlockState(map.getAsCompoundTag("Properties").get(), this.version.getBlockStates()))).collect(Collectors.toList());
        long[] blocks = ((Tag)section.get("BlockStates")).getAsLongArrayTag().get().getValue();
        BlockColorMap.BlockColor[] ret = new BlockColorMap.BlockColor[4096];
        long[] blocksParsed = Chunk.extractFromLong1_16(blocks, palette.size());
        for (int i = 0; i < 4096; ++i) {
            int b = (int)blocksParsed[i];
            if (b >= palette.size()) {
                log.warn("Block " + i + " " + b + " was out of bounds, is this world corrupt?");
                continue;
            }
            ret[i] = (BlockColorMap.BlockColor)palette.get(b);
        }
        return ret;
    }
}

