/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups.de.piegames.blockmap.color;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

public final class Color {
    public static final TypeAdapter<Color> ADAPTER = new TypeAdapter<Color>(){

        public void write(JsonWriter out, Color color) throws IOException {
            out.beginArray();
            if (color.a != 0.0f) {
                out.value((long)Float.floatToIntBits(color.a));
                out.value((long)Float.floatToIntBits(color.r));
                out.value((long)Float.floatToIntBits(color.g));
                out.value((long)Float.floatToIntBits(color.b));
            }
            out.endArray();
        }

        public Color read(JsonReader in) throws IOException {
            in.beginArray();
            Color color = in.hasNext() ? new Color(Float.intBitsToFloat(in.nextInt()), Float.intBitsToFloat(in.nextInt()), Float.intBitsToFloat(in.nextInt()), Float.intBitsToFloat(in.nextInt())) : new Color(0.0f, 0.0f, 0.0f, 0.0f);
            in.endArray();
            return color;
        }
    };
    public static final Color MISSING = new Color(1.0f, 1.0f, 0.0f, 1.0f);
    public static final Color TRANSPARENT = new Color(0.0f, 0.0f, 0.0f, 0.0f);
    public final float r;
    public final float g;
    public final float b;
    public final float a;

    public Color(float a, float r, float g, float b) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
    }

    public Color(double a, double r, double g, double b) {
        this.r = (float)r;
        this.g = (float)g;
        this.b = (float)b;
        this.a = (float)a;
    }

    public int toRGB() {
        return (0xFF & (int)(this.a * 255.0f)) << 24 | (Color.linearRGBTosRGBi(this.r) & 0xFF) << 16 | (Color.linearRGBTosRGBi(this.g) & 0xFF) << 8 | Color.linearRGBTosRGBi(this.b) & 0xFF;
    }

    public static Color fromRGB(int color) {
        return new Color((float)Color.component(color, 24) / 255.0f, Color.sRGBToLinear(Color.component(color, 16)), Color.sRGBToLinear(Color.component(color, 8)), Color.sRGBToLinear(Color.component(color, 0)));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.a);
        result = 31 * result + Float.floatToIntBits(this.b);
        result = 31 * result + Float.floatToIntBits(this.g);
        result = 31 * result + Float.floatToIntBits(this.r);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equals((Color)obj);
    }

    public boolean equals(Color other) {
        return this.a == other.a && this.b == other.b && this.g == other.g && this.r == other.r;
    }

    public String toString() {
        return this.a + " " + this.r + " " + this.g + " " + this.b;
    }

    public static Color multiplyRGB(Color a, Color b) {
        return new Color(a.a, a.r * b.r, a.g * b.g, a.b * b.b);
    }

    public static Color multiplyRGBA(Color a, Color b) {
        return new Color(a.a * b.a, a.r * b.r, a.g * b.g, a.b * b.b);
    }

    static float sRGBToLinear(int component) {
        double tempComponent = (double)component / 255.0;
        tempComponent = tempComponent <= (double)0.04045f ? (tempComponent /= 12.92) : Math.pow((tempComponent + 0.055) / 1.055, 2.4);
        return (float)tempComponent;
    }

    public static double sRGBToLinear(double component) {
        double tempComponent = component;
        tempComponent = tempComponent <= (double)0.04045f ? (tempComponent /= 12.92) : Math.pow((tempComponent + 0.055) / 1.055, 2.4);
        return tempComponent;
    }

    static int linearRGBTosRGBi(float component) {
        double tempComponent = 0.0;
        tempComponent = (double)component <= 0.00318308 ? 12.92 * (double)component : 1.055 * Math.pow(component, 0.4166666666666667) - 0.055;
        return (int)(tempComponent * 255.0);
    }

    public static double linearRGBTosRGB(double component) {
        double tempComponent = 0.0;
        tempComponent = component <= 0.00318308 ? 12.92 * component : 1.055 * Math.pow(component, 0.4166666666666667) - 0.055;
        return tempComponent;
    }

    public static final int component(int color, int shift) {
        return color >> shift & 0xFF;
    }

    public static final int alpha(int color) {
        return Color.component(color, 24);
    }

    public static final Color alphaOver(Color dst, Color src) {
        if ((double)src.a >= 0.99999999) {
            return src;
        }
        float src1A = 1.0f - src.a;
        float outA = src.a + dst.a * src1A;
        if (outA == 0.0f) {
            return TRANSPARENT;
        }
        return new Color(outA, (src.r * src.a + dst.r * dst.a * src1A) / outA, (src.g * src.a + dst.g * dst.a * src1A) / outA, (src.b * src.a + dst.b * dst.a * src1A) / outA);
    }

    public static final Color alphaOver(Color dst, Color src, int times) {
        double pow = Math.pow(1.0f - src.a, times);
        double alpha = 1.0 - (double)(1.0f - dst.a) * pow;
        double alphaDst = (double)dst.a * pow;
        double alphaSrc = alpha - alphaDst;
        alphaSrc /= alpha;
        alphaDst /= alpha;
        if (alpha == 0.0) {
            return TRANSPARENT;
        }
        return new Color(alpha, (double)src.r * alphaSrc + (double)dst.r * alphaDst, (double)src.g * alphaSrc + (double)dst.g * alphaDst, (double)src.b * alphaSrc + (double)dst.b * alphaDst);
    }

    public static final Color alphaUnder(Color dst, Color src) {
        return Color.alphaOver(src, dst);
    }

    public static final Color alphaUnder(Color dst, Color src, int times) {
        if (times == 1) {
            return Color.alphaUnder(dst, src);
        }
        double pow = Math.pow(1.0f - src.a, times);
        double alpha = 1.0 - (double)(1.0f - dst.a) * pow;
        double alphaDst = (double)dst.a * pow;
        double alphaSrc = (double)(1.0f - dst.a) * (alpha - alphaDst);
        alphaSrc /= alpha;
        alphaDst = (double)dst.a / alpha;
        if (alpha == 0.0) {
            return TRANSPARENT;
        }
        return new Color(alpha, (double)src.r * alphaSrc + (double)dst.r * alphaDst, (double)src.g * alphaSrc + (double)dst.g * alphaDst, (double)src.b * alphaSrc + (double)dst.b * alphaDst);
    }

    public static final Color shade(Color color, float factor) {
        if (factor < 0.0f) {
            factor = 1.0f + factor;
            factor = (float)Color.sRGBToLinear(factor);
            return new Color(color.a, color.r * factor, color.g * factor, color.b * factor);
        }
        if (factor > 0.0f) {
            factor = Color.sRGBToLinear((int)(factor * 255.0f));
            factor = 1.0f - factor;
            return new Color(color.a, 1.0f - (1.0f - color.r) * factor, 1.0f - (1.0f - color.g) * factor, 1.0f - (1.0f - color.b) * factor);
        }
        return color;
    }
}

