/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.imageio.ImageIO;
import net.creeperhost.ftbbackups.FTBBackups;
import net.creeperhost.ftbbackups.config.Config;
import net.creeperhost.ftbbackups.data.Backup;
import net.creeperhost.ftbbackups.data.Backups;
import net.creeperhost.ftbbackups.de.piegames.blockmap.MinecraftDimension;
import net.creeperhost.ftbbackups.de.piegames.blockmap.renderer.RegionRenderer;
import net.creeperhost.ftbbackups.de.piegames.blockmap.renderer.RenderSettings;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.org.joml.Vector2ic;
import net.creeperhost.ftbbackups.de.piegames.blockmap.world.Region;
import net.creeperhost.ftbbackups.de.piegames.blockmap.world.RegionFolder;
import net.creeperhost.ftbbackups.utils.FileUtils;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.storage.LevelResource;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;

public class BackupHandler {
    private static Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static Path serverRoot;
    private static Path backupFolderPath;
    private static Path worldFolder;
    private static final AtomicBoolean backupRunning;
    private static final AtomicBoolean backupFailed;
    private static AtomicReference<String> backupPreview;
    public static boolean isDirty;
    public static AtomicReference<Backups> backups;
    private static String failReason;
    private static long lastAutoBackup;
    public static CompletableFuture<Void> currentFuture;

    public static void init(MinecraftServer minecraftServer) {
        serverRoot = minecraftServer.m_6237_().toPath().normalize().toAbsolutePath();
        backupFolderPath = serverRoot.resolve("backups");
        BackupHandler.createBackupFolder(backupFolderPath);
        BackupHandler.loadJson();
        FTBBackups.LOGGER.info("Starting backup cleaning thread");
        if (FTBBackups.backupCleanerWatcherExecutorService.isShutdown()) {
            FTBBackups.backupCleanerWatcherExecutorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("FTB Backups scheduled executor %d").build());
        }
        FTBBackups.backupCleanerWatcherExecutorService.scheduleAtFixedRate(BackupHandler::clean, 0L, 30L, TimeUnit.SECONDS);
    }

    public static String createPreview(MinecraftServer minecraftServer) {
        try {
            MinecraftDimension dim = MinecraftDimension.OVERWORLD;
            RenderSettings settings = new RenderSettings();
            RegionRenderer renderer = new RegionRenderer(settings);
            Path worldPath = minecraftServer.m_129843_(LevelResource.f_78182_).toAbsolutePath();
            Path dimPath = worldPath.resolve(dim.getRegionPath());
            Path previewPath = worldPath.resolve("backupPreview");
            RegionFolder.WorldRegionFolder w = RegionFolder.WorldRegionFolder.load(dimPath, renderer, false);
            RegionFolder.CachedRegionFolder r = RegionFolder.CachedRegionFolder.create(w, false, previewPath);
            try {
                Files.walk(previewPath, new FileVisitOption[0]).forEach(f -> {
                    try {
                        Files.deleteIfExists(f);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                });
                Files.deleteIfExists(previewPath);
                Files.createDirectories(previewPath, new FileAttribute[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Vector2ic lastPos = null;
            long lastTimestamp = 0L;
            for (Vector2ic p : w.listRegions()) {
                try {
                    long thisTimestamp = w.getTimestamp(p);
                    if (thisTimestamp <= lastTimestamp) continue;
                    lastPos = p;
                    lastTimestamp = thisTimestamp;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if (lastPos != null) {
                Region render = r.render(lastPos);
                ImageIO.write((RenderedImage)render.getImage(), "png", baos);
            }
            byte[] image = baos.toByteArray();
            try {
                Files.walk(previewPath, new FileVisitOption[0]).forEach(f -> {
                    try {
                        Files.deleteIfExists(f);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                });
                Files.deleteIfExists(previewPath);
            }
            catch (Exception exception) {
                // empty catch block
            }
            baos.close();
            return "data:image/png;base64, " + Base64.getEncoder().encodeToString(image);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }

    public static boolean isRunning() {
        return backupRunning.get();
    }

    public static void createBackup(MinecraftServer minecraftServer) {
        BackupHandler.createBackup(minecraftServer, false);
    }

    public static void createBackup(MinecraftServer minecraftServer, boolean protect) {
        if (FTBBackups.isShutdown) {
            return;
        }
        if (Config.cached().only_if_players_been_online && !isDirty) {
            FTBBackups.LOGGER.info("Skipping backup, no players have been online since last backup.");
            return;
        }
        worldFolder = minecraftServer.m_129843_(LevelResource.f_78182_).toAbsolutePath();
        FTBBackups.LOGGER.info("Found world folder at " + worldFolder);
        Calendar calendar = Calendar.getInstance();
        String date = calendar.get(1) + "-" + (calendar.get(2) + 1) + "-" + calendar.get(5);
        String time = calendar.get(11) + "-" + calendar.get(12) + "-" + calendar.get(13);
        String backupName = date + "_" + time + ".zip";
        Path backupLocation = backupFolderPath.resolve(backupName);
        if (BackupHandler.canCreateBackup()) {
            lastAutoBackup = System.currentTimeMillis();
            backupRunning.set(true);
            minecraftServer.m_6846_().m_11302_();
            BackupHandler.setNoSave(minecraftServer, true);
            AtomicLong startTime = new AtomicLong(System.nanoTime());
            AtomicLong finishTime = new AtomicLong();
            currentFuture = CompletableFuture.runAsync(() -> {
                try {
                    BackupHandler.alertPlayers(minecraftServer, (Component)new TranslatableComponent("ftbbackups2.backup.starting"));
                    Path backupPath = backupFolderPath.resolve(backupName);
                    LinkedList<Path> backupPaths = new LinkedList<Path>();
                    backupPaths.add(worldFolder);
                    for (String p : Config.cached().additional_directories) {
                        try {
                            Path path = serverRoot.resolve(p);
                            if (!FileUtils.isChildOf(path, serverRoot)) {
                                FTBBackups.LOGGER.warn("Ignoring additional directory {}, as it is not a child of the server root directory.", (Object)p);
                                continue;
                            }
                            if (path.equals(worldFolder)) {
                                FTBBackups.LOGGER.warn("Ignoring additional directory {}, as it is the world folder.", (Object)p);
                                continue;
                            }
                            if (FileUtils.isChildOf(path, worldFolder)) {
                                FTBBackups.LOGGER.warn("Ignoring additional directory {}, as it is a child of the world folder.", (Object)p);
                                continue;
                            }
                            if (FileUtils.isChildOf(path, backupFolderPath)) {
                                FTBBackups.LOGGER.warn("Ignoring additional directory {}, as it is a child of the backups folder.", (Object)p);
                                continue;
                            }
                            if (!Files.isDirectory(path, new LinkOption[0])) {
                                FTBBackups.LOGGER.warn("Ignoring additional directory {}, as it is not a directory..", (Object)p);
                                continue;
                            }
                            if (!Files.exists(path, new LinkOption[0])) continue;
                            backupPaths.add(path);
                        }
                        catch (Exception err) {
                            FTBBackups.LOGGER.error("Failed to add additional directory '{}' to the backup.", (Object)p, (Object)err);
                        }
                    }
                    backupPreview.set(BackupHandler.createPreview(minecraftServer));
                    FileUtils.pack(backupPath, serverRoot, backupPaths);
                    backupFailed.set(false);
                    isDirty = false;
                }
                catch (Exception e) {
                    backupRunning.set(false);
                    backupFailed.set(true);
                    BackupHandler.alertPlayers(minecraftServer, (Component)new TranslatableComponent("ftbbackups2.backup.failed"));
                    FTBBackups.LOGGER.error("Failed to create backup");
                    e.printStackTrace();
                }
            }, FTBBackups.backupExecutor).thenRun(() -> {
                currentFuture = null;
                if (backupFailed.get()) {
                    backupFailed.set(false);
                    backupRunning.set(false);
                    return;
                }
                finishTime.set(System.nanoTime());
                long elapsedTime = finishTime.get() - startTime.get();
                backupRunning.set(false);
                BackupHandler.setNoSave(minecraftServer, false);
                BackupHandler.alertPlayers(minecraftServer, (Component)new TextComponent("Backup finished in " + BackupHandler.format(elapsedTime) + (String)(Config.cached().display_file_size ? " Size: " + FileUtils.getSizeString(backupLocation.toFile().length()) : "")));
                String sha1 = FileUtils.getSha1(backupLocation);
                float ratio = (float)backupLocation.toFile().length() / (float)FileUtils.getFolderSize(worldFolder.toFile());
                FTBBackups.LOGGER.info("Backup size " + FileUtils.getSizeString(backupLocation.toFile().length()) + " World Size " + FileUtils.getSizeString(FileUtils.getFolderSize(worldFolder.toFile())));
                Backup backup = new Backup(worldFolder.normalize().getFileName().toString(), System.currentTimeMillis(), backupLocation.toString(), FileUtils.getSize(backupLocation.toFile()), ratio, sha1, backupPreview.get(), protect);
                BackupHandler.addBackup(backup);
                BackupHandler.updateJson();
                FTBBackups.LOGGER.info("New backup created at " + backupLocation + " size: " + FileUtils.getSizeString(backupLocation) + " Took: " + BackupHandler.format(elapsedTime) + " Sha1: " + sha1);
            });
        } else {
            if (!failReason.isEmpty()) {
                backupRunning.set(false);
                Object failMessage = "Unable to create backup, Reason: " + failReason;
                BackupHandler.alertPlayers(minecraftServer, (Component)new TranslatableComponent((String)failMessage));
                FTBBackups.LOGGER.error((String)failMessage);
                failMessage = "";
            }
            backupRunning.set(false);
        }
    }

    public static void addBackup(Backup backup) {
        backups.getAndUpdate(backups1 -> {
            backups1.add(backup);
            return backups1;
        });
    }

    public static void removeBackup(Backup backup) {
        backups.getAndUpdate(backups1 -> {
            if (backups1.contains(backup)) {
                backups1.remove(backup);
                return backups1;
            }
            return backups1;
        });
    }

    @Nullable
    public static Backup getLatestBackup() {
        if (backups == null) {
            return null;
        }
        if (backups.get().isEmpty()) {
            return null;
        }
        Backup currentNewest = null;
        for (Backup backup : backups.get().getBackups()) {
            if (currentNewest == null) {
                currentNewest = backup;
            }
            if (backup.getCreateTime() <= currentNewest.getCreateTime()) continue;
            currentNewest = backup;
        }
        return currentNewest;
    }

    @Nullable
    public static Backup getOldestBackup() {
        if (backups == null) {
            return null;
        }
        if (backups.get().isEmpty()) {
            return null;
        }
        Backup currentOldest = null;
        for (Backup backup : backups.get().getBackups()) {
            if (backup.isProtected()) continue;
            if (currentOldest == null) {
                currentOldest = backup;
            }
            if (backup.getCreateTime() >= currentOldest.getCreateTime()) continue;
            currentOldest = backup;
        }
        return currentOldest;
    }

    public static void clean() {
        try {
            if (FTBBackups.isShutdown) {
                return;
            }
            if (backupRunning.get()) {
                return;
            }
            if (backups.get().unprotectedSize() > Config.cached().max_backups) {
                FTBBackups.LOGGER.info("More backups than " + Config.cached().max_backups + " found, Removing oldest backup");
                int backupsNeedRemoving = backups.get().unprotectedSize() - Config.cached().max_backups;
                if (backupsNeedRemoving > 0 && BackupHandler.getOldestBackup() != null) {
                    for (int i = 0; i < backupsNeedRemoving; ++i) {
                        Path backupFile = Path.of(BackupHandler.getOldestBackup().getBackupLocation(), new String[0]);
                        if (!Files.exists(backupFile, new LinkOption[0])) continue;
                        boolean removed = Files.deleteIfExists(backupFile);
                        String log = removed ? "Removed old backup " + backupFile.getFileName() : " Failed to remove backup " + backupFile.getFileName();
                        FTBBackups.LOGGER.info(log);
                    }
                    BackupHandler.verifyOldBackups();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void loadJson() {
        Path json = backupFolderPath.resolve("backups.json");
        if (Files.exists(json, new LinkOption[0])) {
            Gson gson = new Gson();
            try {
                FileReader fileReader = new FileReader(json.toFile());
                backups.getAndUpdate(backups1 -> (Backups)gson.fromJson((Reader)fileReader, Backups.class));
                fileReader.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void updateJson() {
        try {
            String jsonString = "[]";
            if (!backups.get().isEmpty()) {
                jsonString = GSON.toJson((Object)backups.get(), Backups.class);
            }
            BackupHandler.writeToFile(jsonString);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void writeToFile(String json) {
        FTBBackups.LOGGER.info("Writing to file " + backupFolderPath.resolve("backups.json"));
        try (FileOutputStream fileOutputStream = new FileOutputStream(backupFolderPath.resolve("backups.json").toFile());){
            IOUtils.write((String)json, (OutputStream)fileOutputStream, (Charset)Charset.defaultCharset());
            fileOutputStream.close();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static boolean canCreateBackup() {
        if (backupFolderPath == null) {
            failReason = "backup folder path is null";
            return false;
        }
        if (!backupFolderPath.toFile().exists()) {
            failReason = "backup folder does not exist";
            return false;
        }
        if (backupRunning.get()) {
            FTBBackups.LOGGER.info("Unable to start new backup as backup is already running");
            failReason = "Unable to start new backup as backup is already running";
            return false;
        }
        if (lastAutoBackup != 0L && Config.cached().manual_backups_time != 0 && System.currentTimeMillis() < lastAutoBackup + 60000L) {
            failReason = "Manuel backup was recently taken";
            return false;
        }
        if (currentFuture != null) {
            failReason = "backup thread is somehow still running";
            FTBBackups.LOGGER.error("currentFuture is not null??");
            return false;
        }
        long free = backupFolderPath.toFile().getFreeSpace();
        long currentWorldSize = FileUtils.getFolderSize(worldFolder.toFile());
        for (String p : Config.cached().additional_directories) {
            try {
                Path path = worldFolder.getParent().resolve(p);
                if (!Files.exists(path, new LinkOption[0]) || !Files.isDirectory(path, new LinkOption[0])) continue;
                currentWorldSize += FileUtils.getFolderSize(path.toFile());
            }
            catch (Exception path) {}
        }
        if (BackupHandler.getLatestBackup() == null) {
            FTBBackups.LOGGER.info("Current world size: " + FileUtils.getSizeString(currentWorldSize) + " Current free space: " + FileUtils.getSizeString(free));
            if (currentWorldSize > free) {
                failReason = "not enough free space on device";
                return false;
            }
        } else {
            long latestBackupSize = BackupHandler.getLatestBackup().getSize();
            float ratio = BackupHandler.getLatestBackup().getRatio();
            long expectedSize = (long)((int)(Math.ceil((float)currentWorldSize * ratio) / 100.0)) * 105L;
            FTBBackups.LOGGER.info("Last backup size: " + FileUtils.getSizeString(latestBackupSize) + " Current world size: " + FileUtils.getSizeString(currentWorldSize) + " Current free space: " + FileUtils.getSizeString(free) + " ExpectedSize " + FileUtils.getSizeString(expectedSize));
            if (expectedSize > free) {
                failReason = "not enough free space on device";
                return false;
            }
        }
        return true;
    }

    public static void verifyOldBackups() {
        if (backups == null) {
            return;
        }
        if (backups.get().isEmpty()) {
            return;
        }
        ArrayList<Backup> backupsCopy = new ArrayList<Backup>(backups.get().getBackups());
        for (Backup backup : backupsCopy) {
            FTBBackups.LOGGER.debug("Verifying backup " + backup.getBackupLocation());
            if (Files.exists(Path.of(backup.getBackupLocation(), new String[0]), new LinkOption[0])) continue;
            BackupHandler.removeBackup(backup);
            FTBBackups.LOGGER.info("File missing, removing from backups " + backup.getBackupLocation());
        }
        BackupHandler.updateJson();
    }

    public static void createBackupFolder(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            boolean backupFolderCreated = path.toFile().mkdirs();
            String log = backupFolderCreated ? "Created backup folder at " + path.toAbsolutePath() : "Failed to create backup folder at " + path.toAbsolutePath();
            FTBBackups.LOGGER.info(log);
        }
    }

    public static void setNoSave(MinecraftServer minecraftServer, boolean value) {
        for (ServerLevel level : minecraftServer.m_129785_()) {
            if (level == null) continue;
            FTBBackups.LOGGER.info("Setting world " + level.m_46472_().m_135782_() + " save state to " + value);
            level.f_8564_ = value;
        }
    }

    public static void alertPlayers(MinecraftServer minecraftServer, Component message) {
        if (Config.cached().do_not_notify) {
            return;
        }
        if (Config.cached().notify_op_only && minecraftServer instanceof DedicatedServer) {
            for (ServerPlayer player : minecraftServer.m_6846_().m_11314_()) {
                if (!player.m_20310_(4)) continue;
                player.m_6352_(message, Util.f_137441_);
            }
        } else {
            for (ServerPlayer player : minecraftServer.m_6846_().m_11314_()) {
                player.m_6352_(message, Util.f_137441_);
            }
        }
    }

    public static String format(long nano) {
        Duration duration = Duration.ofNanos(nano);
        long mins = duration.toMinutes();
        long seconds = duration.minusMinutes(mins).toSeconds();
        long mili = duration.minusSeconds(seconds).toMillis();
        return mins + "m, " + seconds + "s, " + mili + "ms";
    }

    static {
        backupRunning = new AtomicBoolean(false);
        backupFailed = new AtomicBoolean(false);
        backupPreview = new AtomicReference<String>("");
        isDirty = false;
        backups = new AtomicReference<Backups>(new Backups());
        failReason = "";
        lastAutoBackup = 0L;
    }
}

