/*
 * Decompiled with CFR 0.152.
 */
package com.affehund.voidtotem.core;

import java.util.ArrayList;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="voidtotem", bus=Mod.EventBusSubscriber.Bus.MOD)
public class VoidTotemConfig {
    public static final ForgeConfigSpec COMMON_CONFIG_SPEC;
    public static final VoidCommonConfig COMMON_CONFIG;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(VoidCommonConfig::new);
        COMMON_CONFIG_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON_CONFIG = (VoidCommonConfig)specPair.getLeft();
    }

    public static class VoidCommonConfig {
        public final ForgeConfigSpec.BooleanValue ADD_END_CITY_TREASURE;
        public final ForgeConfigSpec.ConfigValue<ArrayList<String>> BLACKLISTED_DIMENSIONS;
        public final ForgeConfigSpec.BooleanValue NEEDS_TOTEM;
        public final ForgeConfigSpec.BooleanValue SHOW_TOTEM_TOOLTIP;
        public final ForgeConfigSpec.IntValue TELEPORT_HEIGHT_OFFSET;
        public final ForgeConfigSpec.BooleanValue USE_TOTEM_FROM_INVENTORY;

        public VoidCommonConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Void Totem Common Config").push("general");
            this.ADD_END_CITY_TREASURE = builder.comment("This sets whether the void totem will be added to the end city treasure.").define("add_end_city_treasure", true);
            this.BLACKLISTED_DIMENSIONS = builder.comment("This adds dimensions to a blacklist where you die if you fall into the void. Example: \"minecraft:overworld\".").define("blacklisted_dimensions", new ArrayList());
            this.NEEDS_TOTEM = builder.comment("This sets whether you need a totem to prevent death when falling into the void.").define("needs_totem", true);
            this.SHOW_TOTEM_TOOLTIP = builder.comment("This sets whether a tooltip is shown on the totem.").define("show_totem_tooltip", true);
            this.TELEPORT_HEIGHT_OFFSET = builder.comment("This sets the height offset you will be teleported when you can't be placed on a block.").defineInRange("teleport_height_offset", 64, 0, 1024);
            this.USE_TOTEM_FROM_INVENTORY = builder.comment("This sets whether you can use a totem from anywhere in your inventory.").define("use_totem_from_inventory", false);
            builder.pop();
        }
    }
}

