/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.datagen.customrecipes;

import com.direwolf20.laserio.datagen.customrecipes.CardClearRecipe;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;

public class CardClearRecipeBuilder
implements RecipeBuilder {
    private final Item result;
    private final int count;
    private final List<Ingredient> ingredients = Lists.newArrayList();
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();
    @Nullable
    private String group;

    public CardClearRecipeBuilder(ItemLike result, int count) {
        this.result = result.m_5456_();
        this.count = count;
    }

    public static CardClearRecipeBuilder shapeless(ItemLike p_126190_) {
        return new CardClearRecipeBuilder(p_126190_, 1);
    }

    public static CardClearRecipeBuilder shapeless(ItemLike p_126192_, int p_126193_) {
        return new CardClearRecipeBuilder(p_126192_, p_126193_);
    }

    public CardClearRecipeBuilder requires(TagKey<Item> p_206420_) {
        return this.requires(Ingredient.m_204132_(p_206420_));
    }

    public CardClearRecipeBuilder requires(ItemLike p_126210_) {
        return this.requires(p_126210_, 1);
    }

    public CardClearRecipeBuilder requires(ItemLike p_126212_, int p_126213_) {
        for (int i = 0; i < p_126213_; ++i) {
            this.requires(Ingredient.m_43929_((ItemLike[])new ItemLike[]{p_126212_}));
        }
        return this;
    }

    public CardClearRecipeBuilder requires(Ingredient p_126185_) {
        return this.requires(p_126185_, 1);
    }

    public CardClearRecipeBuilder requires(Ingredient p_126187_, int p_126188_) {
        for (int i = 0; i < p_126188_; ++i) {
            this.ingredients.add(p_126187_);
        }
        return this;
    }

    public CardClearRecipeBuilder unlockedBy(String p_126197_, CriterionTriggerInstance p_126198_) {
        this.advancement.m_138386_(p_126197_, p_126198_);
        return this;
    }

    public CardClearRecipeBuilder group(@Nullable String p_126195_) {
        this.group = p_126195_;
        return this;
    }

    public Item m_142372_() {
        return this.result;
    }

    public void m_142700_(Consumer<FinishedRecipe> p_126205_, ResourceLocation p_126206_) {
        this.ensureValid(p_126206_);
        this.advancement.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)p_126206_)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)p_126206_)).m_138360_(RequirementsStrategy.f_15979_);
        p_126205_.accept((FinishedRecipe)new Result(p_126206_, this.result, this.count, this.group == null ? "" : this.group, this.ingredients, this.advancement, new ResourceLocation(p_126206_.m_135827_(), "recipes/" + this.result.m_41471_().m_40783_() + "/" + p_126206_.m_135815_())));
    }

    private void ensureValid(ResourceLocation p_126208_) {
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + p_126208_);
        }
    }

    public static class Result
    extends ShapelessRecipeBuilder.Result {
        public Result(ResourceLocation resourceLocation, Item result, int count, String group, List<Ingredient> ingredients, Advancement.Builder advancement, ResourceLocation advancementId) {
            super(resourceLocation, result, count, group, ingredients, advancement, advancementId);
        }

        public RecipeSerializer<?> m_6637_() {
            return CardClearRecipe.SERIALIZER;
        }
    }
}

