/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.blockentities.basebe;

import com.direwolf20.laserio.common.blockentities.LaserNodeBE;
import com.direwolf20.laserio.common.items.LaserWrench;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class BaseLaserBE
extends BlockEntity {
    protected final Set<BlockPos> connections = new CopyOnWriteArraySet<BlockPos>();
    protected final Set<BlockPos> renderedConnections = new CopyOnWriteArraySet<BlockPos>();

    public BaseLaserBE(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public LaserNodeBE getNodeAt(BlockPos pos) {
        BlockEntity be = this.f_58857_.m_7702_(pos);
        if (be instanceof LaserNodeBE) {
            return (LaserNodeBE)be;
        }
        return null;
    }

    public void discoverAllNodes() {
        HashSet<BlockPos> otherNodesInNetwork = new HashSet<BlockPos>();
        LinkedList<BlockPos> nodesToCheck = new LinkedList<BlockPos>();
        HashSet<BlockPos> checkedNodes = new HashSet<BlockPos>();
        nodesToCheck.add(this.m_58899_());
        while (nodesToCheck.size() > 0) {
            BlockEntity be;
            BlockPos posToCheck = (BlockPos)nodesToCheck.remove();
            if (!checkedNodes.add(posToCheck) || !((be = this.f_58857_.m_7702_(posToCheck)) instanceof BaseLaserBE)) continue;
            Set<BlockPos> connectedNodes = ((BaseLaserBE)be).getWorldConnections();
            nodesToCheck.addAll(connectedNodes);
            if (!(be instanceof LaserNodeBE)) continue;
            otherNodesInNetwork.add(posToCheck);
        }
        for (BlockPos pos : otherNodesInNetwork) {
            LaserNodeBE nodeBE = this.getNodeAt(pos);
            if (nodeBE == null) continue;
            nodeBE.setOtherNodesInNetwork(otherNodesInNetwork);
        }
    }

    public boolean addNode(BlockPos pos) {
        return this.connections.add(this.getRelativePos(pos));
    }

    public boolean addRenderNode(BlockPos pos) {
        boolean success = this.renderedConnections.add(this.getRelativePos(pos));
        if (success) {
            this.markDirtyClient();
        } else {
            this.m_6596_();
        }
        return success;
    }

    public boolean removeNode(BlockPos pos) {
        BlockPos relativePos = this.getRelativePos(pos);
        this.connections.remove(relativePos);
        boolean success = this.renderedConnections.remove(relativePos);
        if (success) {
            this.markDirtyClient();
        } else {
            this.m_6596_();
        }
        return success;
    }

    public boolean isNodeConnected(BlockPos pos) {
        return this.connections.contains(this.getRelativePos(pos));
    }

    public BlockPos getWorldPos(BlockPos relativePos) {
        return this.m_58899_().m_141952_((Vec3i)relativePos);
    }

    public BlockPos getRelativePos(BlockPos worldPos) {
        return worldPos.m_141950_((Vec3i)this.m_58899_());
    }

    public void handleConnection(BaseLaserBE be) {
        BlockPos connectingPos = be.m_58899_();
        if (this.isNodeConnected(connectingPos)) {
            this.removeConnection(connectingPos, be);
        } else {
            this.addConnection(connectingPos, be);
        }
    }

    public void addConnection(BlockPos connectingPos, BaseLaserBE be) {
        this.addNode(connectingPos);
        be.addNode(this.m_58899_());
        this.addRenderNode(connectingPos);
        this.discoverAllNodes();
    }

    public void removeConnection(BlockPos connectingPos, BaseLaserBE be) {
        this.removeNode(connectingPos);
        be.removeNode(this.m_58899_());
        this.discoverAllNodes();
        be.discoverAllNodes();
    }

    public Set<BlockPos> getConnections() {
        return this.connections;
    }

    public Set<BlockPos> getWorldConnections() {
        HashSet<BlockPos> worldConnections = new HashSet<BlockPos>();
        for (BlockPos relativePos : this.connections) {
            worldConnections.add(this.getWorldPos(relativePos));
        }
        return worldConnections;
    }

    public Set<BlockPos> getRenderedConnections() {
        return this.renderedConnections;
    }

    public void disconnectAllNodes() {
        HashSet<BaseLaserBE> connectionsToUpdate = new HashSet<BaseLaserBE>();
        for (BlockPos pos : this.connections) {
            BlockPos connectingPos = this.getWorldPos(pos);
            BlockEntity be = this.f_58857_.m_7702_(connectingPos);
            if (!(be instanceof BaseLaserBE)) continue;
            ((BaseLaserBE)be).removeNode(this.m_58899_());
            connectionsToUpdate.add((BaseLaserBE)be);
        }
        this.connections.clear();
        for (BaseLaserBE be : connectionsToUpdate) {
            be.discoverAllNodes();
        }
        this.discoverAllNodes();
    }

    public void validateConnections(BlockPos originalPos) {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        HashSet<BaseLaserBE> connectionsToUpdate = new HashSet<BaseLaserBE>();
        BlockPos movedPos = this.m_58899_().m_141950_((Vec3i)originalPos);
        for (BlockPos pos : this.connections) {
            BlockPos oldPos = pos.m_141950_((Vec3i)movedPos);
            BlockPos oldWorldPos = this.getWorldPos(oldPos);
            BlockEntity oldBe = this.f_58857_.m_7702_(oldWorldPos);
            if (!(oldBe instanceof BaseLaserBE)) continue;
            BaseLaserBE baseLaserBE = (BaseLaserBE)oldBe;
            boolean wasRender = this.renderedConnections.contains(pos);
            baseLaserBE.removeNode(originalPos);
            this.removeNode(baseLaserBE.m_58899_().m_141952_((Vec3i)movedPos));
            connectionsToUpdate.add(baseLaserBE);
            if (!oldWorldPos.m_123314_((Vec3i)this.m_58899_(), (double)LaserWrench.maxDistance)) continue;
            this.addNode(baseLaserBE.m_58899_());
            baseLaserBE.addNode(this.m_58899_());
            if (wasRender) {
                this.addRenderNode(baseLaserBE.m_58899_());
                continue;
            }
            baseLaserBE.addRenderNode(this.m_58899_());
        }
        for (BlockPos pos : this.connections) {
            BlockPos connectingPos = this.getWorldPos(pos);
            BlockEntity be = this.f_58857_.m_7702_(connectingPos);
            if (be instanceof BaseLaserBE) continue;
            this.removeNode(this.getWorldPos(pos));
        }
        for (BaseLaserBE be : connectionsToUpdate) {
            be.discoverAllNodes();
        }
        this.discoverAllNodes();
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.connections.clear();
        ListTag connections = tag.m_128437_("connections", 10);
        for (int i = 0; i < connections.size(); ++i) {
            BlockPos blockPos = NbtUtils.m_129239_((CompoundTag)connections.m_128728_(i).m_128469_("pos"));
            this.connections.add(blockPos);
        }
        this.renderedConnections.clear();
        ListTag renderedConnections = tag.m_128437_("renderedConnections", 10);
        for (int i = 0; i < renderedConnections.size(); ++i) {
            BlockPos blockPos = NbtUtils.m_129239_((CompoundTag)renderedConnections.m_128728_(i).m_128469_("pos"));
            this.renderedConnections.add(blockPos);
        }
        BlockPos originalPos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("myWorldPos"));
        if (!originalPos.equals((Object)this.m_58899_()) && !originalPos.equals((Object)BlockPos.f_121853_)) {
            this.validateConnections(originalPos);
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ListTag connections = new ListTag();
        for (BlockPos blockPos : this.connections) {
            CompoundTag comp = new CompoundTag();
            comp.m_128365_("pos", (Tag)NbtUtils.m_129224_((BlockPos)blockPos));
            connections.add((Object)comp);
        }
        tag.m_128365_("connections", (Tag)connections);
        ListTag renderedConnections = new ListTag();
        for (BlockPos blockPos : this.renderedConnections) {
            CompoundTag comp = new CompoundTag();
            comp.m_128365_("pos", (Tag)NbtUtils.m_129224_((BlockPos)blockPos));
            renderedConnections.add((Object)comp);
        }
        tag.m_128365_("renderedConnections", (Tag)renderedConnections);
        tag.m_128365_("myWorldPos", (Tag)NbtUtils.m_129224_((BlockPos)this.m_58899_()));
    }

    @Nonnull
    public AABB getRenderBoundingBox() {
        return new AABB(this.m_58899_().m_6630_(10).m_142390_(10).m_142385_(10), this.m_58899_().m_6625_(10).m_142383_(10).m_142386_(10));
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    public void markDirtyClient() {
        this.m_6596_();
        if (this.m_58904_() != null) {
            BlockState state = this.m_58904_().m_8055_(this.m_58899_());
            this.m_58904_().m_7260_(this.m_58899_(), state, state, 3);
        }
    }

    public void m_7651_() {
        super.m_7651_();
    }

    public void m_6339_() {
        super.m_6339_();
    }
}

