/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.world.block;

import java.util.Random;
import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.block.IQuarkBlock;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.content.world.block.GlowShroomRingBlock;
import vazkii.quark.content.world.module.GlimmeringWealdModule;

public class HugeGlowShroomBlock
extends HugeMushroomBlock
implements IQuarkBlock {
    private final QuarkModule module;
    private final boolean glowing;

    public HugeGlowShroomBlock(String name, QuarkModule module, boolean glowing) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50181_).m_60953_(b -> glowing ? 12 : 0).m_60977_().m_60955_());
        this.module = module;
        this.glowing = glowing;
        RegistryHelper.registerBlock((Block)this, (String)name);
        RegistryHelper.setCreativeTab((Block)this, (CreativeModeTab)CreativeModeTab.f_40750_);
    }

    public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return false;
    }

    @Override
    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 0;
    }

    @Override
    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(@Nonnull BlockState stateIn, @Nonnull Level worldIn, @Nonnull BlockPos pos, @Nonnull Random rand) {
        super.m_7100_(stateIn, worldIn, pos, rand);
        BlockState below = worldIn.m_8055_(pos.m_7495_());
        if (this.glowing && rand.nextInt(10) == 0 && (below.m_60795_() || below.m_60734_() == GlimmeringWealdModule.glow_shroom_ring)) {
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123810_, (double)pos.m_123341_() + rand.nextDouble(), (double)pos.m_123342_(), (double)pos.m_123343_() + rand.nextDouble(), 0.0, -0.05 - Math.random() * 0.05, 0.0);
        }
    }

    public static boolean place(LevelAccessor worldIn, Random rand, BlockPos pos) {
        int i;
        int i2;
        Block block = worldIn.m_8055_(pos.m_7495_()).m_60734_();
        if (block != Blocks.f_152550_) {
            return false;
        }
        BlockPos placePos = pos;
        BlockState stem = GlimmeringWealdModule.glow_shroom_stem.m_49966_();
        BlockState ring = GlimmeringWealdModule.glow_shroom_ring.m_49966_();
        BlockState cap = (BlockState)GlimmeringWealdModule.glow_shroom_block.m_49966_().m_61124_((Property)f_54132_, (Comparable)Boolean.valueOf(false));
        int stemHeight1 = 2;
        int stemHeight2 = rand.nextInt(4);
        boolean hasBigCap = rand.nextDouble() < 0.6;
        int totalHeight = stemHeight1 + stemHeight2 + (hasBigCap ? 2 : 1);
        int horizCheck = 2;
        for (i2 = -horizCheck; i2 < horizCheck + 1; ++i2) {
            for (int j = -horizCheck; j < horizCheck + 1; ++j) {
                for (int k = 1; k < totalHeight; ++k) {
                    if (worldIn.m_8055_(placePos.m_142082_(i2, k, j)).m_60795_()) continue;
                    return false;
                }
            }
        }
        for (i2 = 0; i2 < stemHeight1; ++i2) {
            worldIn.m_7731_(placePos, stem, 2);
            placePos = placePos.m_7494_();
        }
        if (stemHeight2 > 0) {
            Direction dir = MiscUtil.HORIZONTALS[rand.nextInt(MiscUtil.HORIZONTALS.length)];
            placePos = placePos.m_142300_(dir);
        }
        for (int i3 = 0; i3 < stemHeight2; ++i3) {
            worldIn.m_7731_(placePos, stem, 2);
            placePos = placePos.m_7494_();
        }
        int ringHeight = Math.min(2, stemHeight2);
        for (i = 0; i < ringHeight; ++i) {
            for (Direction ringDir : MiscUtil.HORIZONTALS) {
                worldIn.m_7731_(placePos.m_142300_(ringDir).m_5484_(Direction.DOWN, i + 1), (BlockState)ring.m_61124_((Property)GlowShroomRingBlock.FACING, (Comparable)ringDir), 2);
            }
        }
        for (i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                worldIn.m_7731_(placePos.m_142082_(i, 0, j), cap, 2);
            }
        }
        if (hasBigCap) {
            worldIn.m_7731_(placePos.m_7494_(), cap, 2);
        }
        return true;
    }

    @Override
    public QuarkModule getModule() {
        return this.module;
    }

    @Override
    public IQuarkBlock setCondition(BooleanSupplier condition) {
        return this;
    }

    @Override
    public boolean doesConditionApply() {
        return true;
    }
}

