/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tweaks.module;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WallSkullBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.world.NoteBlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;

@LoadModule(category=ModuleCategory.TWEAKS, hasSubscriptions=true)
public class NoteBlockMobSoundsModule
extends QuarkModule {
    public static final Direction[] SKULL_SEARCH_FACINGS = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST};

    @SubscribeEvent
    public void noteBlockPlayed(NoteBlockEvent.Play event) {
        Direction dir;
        BlockPos pos;
        LevelAccessor world = event.getWorld();
        if (world.m_8055_(pos = event.getPos()).m_60734_() != Blocks.f_50065_) {
            return;
        }
        SoundEvent sound = null;
        Direction[] directionArray = MiscUtil.HORIZONTALS;
        int n = directionArray.length;
        for (int i = 0; i < n && (sound = this.getSoundEvent(world, pos, dir = directionArray[i])) == null; ++i) {
        }
        if (sound != null) {
            event.setCanceled(true);
            float pitch = (float)Math.pow(2.0, (double)(event.getVanillaNoteId() - 12) / 12.0);
            world.m_5594_(null, pos.m_7494_(), sound, SoundSource.BLOCKS, 1.0f, pitch);
        }
    }

    public SoundEvent getSoundEvent(LevelAccessor world, BlockPos pos, Direction direction) {
        BlockState state = world.m_8055_(pos.m_142300_(direction));
        Block block = state.m_60734_();
        if (block instanceof WallSkullBlock && state.m_61143_((Property)WallSkullBlock.f_58097_) == direction) {
            if (block == Blocks.f_50311_) {
                return SoundEvents.f_12423_;
            }
            if (block == Blocks.f_50313_) {
                return SoundEvents.f_12559_;
            }
            if (block == Blocks.f_50315_) {
                return SoundEvents.f_12598_;
            }
            if (block == Blocks.f_50319_) {
                return SoundEvents.f_11837_;
            }
            if (block == Blocks.f_50321_) {
                return SoundEvents.f_11890_;
            }
        }
        return null;
    }
}

