/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.mobs.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nonnull;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import vazkii.quark.content.mobs.entity.Frog;

public class FrogModel
extends EntityModel<Frog> {
    private float frogSize;
    public final ModelPart headTop;
    public final ModelPart headBottom;
    public final ModelPart body;
    public final ModelPart rightArm;
    public final ModelPart leftArm;
    public final ModelPart rightEye;
    public final ModelPart leftEye;

    public FrogModel(ModelPart root) {
        this.headTop = root.m_171324_("headTop");
        this.headBottom = root.m_171324_("headBottom");
        this.body = root.m_171324_("body");
        this.rightArm = root.m_171324_("rightArm");
        this.leftArm = root.m_171324_("leftArm");
        this.rightEye = root.m_171324_("rightEye");
        this.leftEye = root.m_171324_("leftEye");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        root.m_171599_("rightArm", CubeListBuilder.m_171558_().m_171480_().m_171514_(33, 7).m_171481_(-1.0f, -1.0f, -5.0f, 3.0f, 3.0f, 6.0f), PartPose.m_171419_((float)6.5f, (float)22.0f, (float)1.0f));
        root.m_171599_("leftArm", CubeListBuilder.m_171558_().m_171514_(33, 7).m_171481_(-2.0f, -1.0f, -5.0f, 3.0f, 3.0f, 6.0f), PartPose.m_171419_((float)-6.5f, (float)22.0f, (float)1.0f));
        root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 7).m_171481_(-5.5f, -3.0f, 0.0f, 11.0f, 7.0f, 11.0f), PartPose.m_171419_((float)0.0f, (float)20.0f, (float)0.0f));
        root.m_171599_("headTop", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-5.5f, -1.0f, -5.0f, 11.0f, 2.0f, 5.0f), PartPose.m_171419_((float)0.0f, (float)18.0f, (float)0.0f));
        root.m_171599_("headBottom", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171481_(-5.5f, 1.0f, -5.0f, 11.0f, 2.0f, 5.0f), PartPose.m_171419_((float)0.0f, (float)18.0f, (float)0.0f));
        root.m_171599_("rightEye", CubeListBuilder.m_171558_().m_171480_().m_171514_(0, 0).m_171481_(1.5f, -1.5f, -4.0f, 1.0f, 1.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)18.0f, (float)0.0f));
        root.m_171599_("leftEye", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-2.5f, -1.5f, -4.0f, 1.0f, 1.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)18.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)32);
    }

    public void prepareMobModel(Frog frog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        int rawTalkTime = frog.getTalkTime();
        this.headBottom.f_104203_ = 0.02617994f;
        if (rawTalkTime != 0) {
            float talkTime = (float)rawTalkTime - partialTickTime;
            int speed = 10;
            this.headBottom.f_104203_ = (float)((double)this.headBottom.f_104203_ + 0.39269908169872414 * (double)(1.0f - Mth.m_14089_((float)(talkTime * (float)Math.PI * 2.0f / (float)speed))));
        }
    }

    public void setupAnim(Frog frog, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.frogSize = frog.getSizeModifier();
        this.rightArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 2.0f / 3.0f)) * 1.0f * limbSwingAmount;
        this.leftArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 2.0f / 3.0f)) * 1.0f * limbSwingAmount;
        this.rightEye.f_104203_ = this.leftEye.f_104203_ = (this.headTop.f_104203_ = headPitch * (float)Math.PI / 180.0f);
        this.headBottom.f_104203_ += headPitch * (float)Math.PI / 180.0f;
        if (frog.isVoid()) {
            this.headTop.f_104203_ *= -1.0f;
            this.rightEye.f_104203_ *= -1.0f;
            this.leftEye.f_104203_ *= -1.0f;
            this.headBottom.f_104203_ *= -1.0f;
        }
    }

    public void m_7695_(PoseStack matrix, @Nonnull VertexConsumer vb, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        matrix.m_85836_();
        matrix.m_85837_(0.0, 1.5 - (double)this.frogSize * 1.5, 0.0);
        matrix.m_85841_(this.frogSize, this.frogSize, this.frogSize);
        if (this.f_102610_) {
            matrix.m_85836_();
            matrix.m_85837_(0.0, 0.6, 0.0);
            matrix.m_85841_(0.625f, 0.625f, 0.625f);
        }
        this.headTop.m_104306_(matrix, vb, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        this.headBottom.m_104306_(matrix, vb, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        this.rightEye.m_104306_(matrix, vb, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        this.leftEye.m_104306_(matrix, vb, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        if (this.f_102610_) {
            matrix.m_85849_();
            matrix.m_85841_(0.5f, 0.5f, 0.5f);
            matrix.m_85837_(0.0, 1.5, 0.0);
        }
        this.rightArm.m_104306_(matrix, vb, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        this.leftArm.m_104306_(matrix, vb, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        this.body.m_104306_(matrix, vb, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        matrix.m_85849_();
    }
}

