/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.addons.oddities.util;

import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.DyeColor;

public record TinyPotatoInfo(int runeColor, boolean enchanted, String name) {
    private static final List<String> RAINBOW_NAMES = List.of("gay homosexual", "rainbow", "lgbt", "lgbtq", "lgbtq+", "gay");
    private static final List<String> ENCHANTMENT_NAMES = List.of("enchanted", "glowy", "shiny", "gay");

    private static boolean matches(String name, String match) {
        return name.equals(match) || name.startsWith(match + " ");
    }

    private static String removeFromFront(String name, String match) {
        return name.substring(match.length()).trim();
    }

    public static TinyPotatoInfo fromComponent(Component component) {
        return TinyPotatoInfo.fromString(component.getString());
    }

    public static TinyPotatoInfo fromString(String string) {
        if ((string = ChatFormatting.m_126649_((String)string)) == null) {
            return new TinyPotatoInfo(-1, false, "");
        }
        string = string.trim().toLowerCase(Locale.ROOT);
        boolean enchanted = false;
        for (String enchant : ENCHANTMENT_NAMES) {
            if (!TinyPotatoInfo.matches(string, enchant)) continue;
            enchanted = true;
            string = TinyPotatoInfo.removeFromFront(string, enchant);
            break;
        }
        int color = -1;
        if (enchanted) {
            for (DyeColor dyeColor : DyeColor.values()) {
                String key = dyeColor.m_7912_().replace("_", " ");
                if (TinyPotatoInfo.matches(string, key)) {
                    color = dyeColor.m_41060_();
                    string = TinyPotatoInfo.removeFromFront(string, key);
                    break;
                }
                if (!key.contains("gray") || !TinyPotatoInfo.matches(string, key = key.replace("gray", "grey"))) continue;
                color = dyeColor.m_41060_();
                string = TinyPotatoInfo.removeFromFront(string, key);
                break;
            }
            if (color == -1) {
                for (String rainbow : RAINBOW_NAMES) {
                    if (!TinyPotatoInfo.matches(string, rainbow)) continue;
                    color = 16;
                    string = TinyPotatoInfo.removeFromFront(string, rainbow);
                    break;
                }
            }
        }
        return new TinyPotatoInfo(color, enchanted, string);
    }
}

