/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.network;

import java.util.function.Supplier;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.core.ModBlockEntities;
import me.desht.modularrouters.logic.RouterRedstoneBehaviour;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.network.NetworkEvent;

public class RouterSettingsMessage {
    private final boolean ecoMode;
    private final RouterRedstoneBehaviour redstoneBehaviour;
    private final ModularRouterBlockEntity.EnergyDirection energyDirection;
    private final BlockPos pos;

    public RouterSettingsMessage(ModularRouterBlockEntity router) {
        this.pos = router.m_58899_();
        this.redstoneBehaviour = router.getRedstoneBehaviour();
        this.ecoMode = router.getEcoMode();
        this.energyDirection = router.getEnergyDirection();
    }

    RouterSettingsMessage(FriendlyByteBuf buffer) {
        this.pos = buffer.m_130135_();
        this.redstoneBehaviour = RouterRedstoneBehaviour.values()[buffer.readByte()];
        this.ecoMode = buffer.readBoolean();
        this.energyDirection = (ModularRouterBlockEntity.EnergyDirection)buffer.m_130066_(ModularRouterBlockEntity.EnergyDirection.class);
    }

    public void toBytes(FriendlyByteBuf byteBuf) {
        byteBuf.m_130064_(this.pos);
        byteBuf.writeByte(this.redstoneBehaviour.ordinal());
        byteBuf.writeBoolean(this.ecoMode);
        byteBuf.m_130068_((Enum)this.energyDirection);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Level w = ((NetworkEvent.Context)ctx.get()).getSender() == null ? ClientUtil.theClientWorld() : ((NetworkEvent.Context)ctx.get()).getSender().m_183503_();
            w.m_141902_(this.pos, (BlockEntityType)ModBlockEntities.MODULAR_ROUTER.get()).ifPresent(router -> {
                router.setRedstoneBehaviour(this.redstoneBehaviour);
                router.setEcoMode(this.ecoMode);
                router.setEnergyDirection(this.energyDirection);
            });
        });
        ctx.get().setPacketHandled(true);
    }
}

