/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.datagen;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.datagen.ModBlockStateProvider;
import me.desht.modularrouters.item.augment.AugmentItem;
import me.desht.modularrouters.item.module.ModuleItem;
import me.desht.modularrouters.item.smartfilter.SmartFilterItem;
import me.desht.modularrouters.item.upgrade.UpgradeItem;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class ModItemModelProvider
extends ItemModelProvider {
    private static final ResourceLocation GENERATED = new ResourceLocation("item/generated");

    public ModItemModelProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "modularrouters", existingFileHelper);
    }

    @Nonnull
    public String m_6055_() {
        return "Modular Routers Item Models";
    }

    protected void registerModels() {
        for (Item item : ForgeRegistries.ITEMS.getValues()) {
            String name = item.getRegistryName().m_135815_();
            if (item instanceof ModuleItem) {
                if (item == ModItems.DISTRIBUTOR_MODULE.get()) {
                    ItemModelBuilder distributorPull = this.simpleItemVariant((Item)ModItems.DISTRIBUTOR_MODULE.get(), "_pull", ModBlockStateProvider.modid("item/module/module_layer0", new Object[0]), ModBlockStateProvider.modid("item/module/module_layer1", new Object[0]), ModBlockStateProvider.modid("item/module/distributor_module_pull", new Object[0]));
                    this.simpleItem((Item)ModItems.DISTRIBUTOR_MODULE.get(), ModBlockStateProvider.modid("item/module/module_layer0", new Object[0]), ModBlockStateProvider.modid("item/module/module_layer1", new Object[0]), ModBlockStateProvider.modid("item/module/distributor_module", new Object[0])).override().predicate(this.modLoc("mode"), 0.5f).model((ModelFile)distributorPull);
                    continue;
                }
                this.simpleItem(item, ModBlockStateProvider.modid("item/module/module_layer0", new Object[0]), ModBlockStateProvider.modid("item/module/module_layer1", new Object[0]), ModBlockStateProvider.modid("item/module/" + name, new Object[0]));
                continue;
            }
            if (item instanceof UpgradeItem) {
                this.simpleItem(item, ModBlockStateProvider.modid("item/upgrade/upgrade_layer0", new Object[0]), ModBlockStateProvider.modid("item/upgrade/upgrade_layer1", new Object[0]), ModBlockStateProvider.modid("item/upgrade/" + name, new Object[0]));
                continue;
            }
            if (item instanceof AugmentItem) {
                this.simpleItem(item, ModBlockStateProvider.modid("item/augment/augment_layer0", new Object[0]), ModBlockStateProvider.modid("item/augment/" + name, new Object[0]));
                continue;
            }
            if (!(item instanceof SmartFilterItem)) continue;
            this.simpleItem(item, ModBlockStateProvider.modid("item/filter/" + name, new Object[0]));
        }
        this.simpleItem((Supplier<Item>)ModItems.BLANK_MODULE, ModBlockStateProvider.modid("item/module/module_layer0", new Object[0]), ModBlockStateProvider.modid("item/module/module_layer1", new Object[0]));
        this.simpleItem((Supplier<Item>)ModItems.BLANK_UPGRADE, ModBlockStateProvider.modid("item/upgrade/upgrade_layer0", new Object[0]), ModBlockStateProvider.modid("item/upgrade/upgrade_layer1", new Object[0]));
        this.simpleItem((Supplier<Item>)ModItems.AUGMENT_CORE, ModBlockStateProvider.modid("item/augment/augment_layer0", new Object[0]));
        this.simpleItem((Supplier<Item>)ModItems.OVERRIDE_CARD, ModBlockStateProvider.modid("item/override_card", new Object[0]));
        ((ItemModelBuilder)this.withExistingParent("manual", GENERATED)).texture("layer0", ModBlockStateProvider.modid("item/manual", new Object[0]));
    }

    private ItemModelBuilder simpleItem(Supplier<Item> item, String ... textures) {
        return this.simpleItem(item.get(), textures);
    }

    private ItemModelBuilder simpleItem(Item item, String ... textures) {
        ItemModelBuilder builder = (ItemModelBuilder)this.withExistingParent(item.getRegistryName().m_135815_(), GENERATED);
        for (int i = 0; i < textures.length; ++i) {
            builder.texture("layer" + i, textures[i]);
        }
        return builder;
    }

    private ItemModelBuilder simpleItemVariant(Item item, String suffix, String ... textures) {
        ItemModelBuilder builder = (ItemModelBuilder)this.withExistingParent(item.getRegistryName().m_135815_() + suffix, GENERATED);
        for (int i = 0; i < textures.length; ++i) {
            builder.texture("layer" + i, textures[i]);
        }
        return builder;
    }
}

